/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import pl.edu.icm.yadda.service2.exception.DataAccessException;
import pl.edu.icm.yadda.service2.exception.ServiceException;
import pl.edu.icm.yadda.service3.archive.db.IContentPartDao2;

public class ChunkWriterPerformanceTest {
    public static void main(String[] args) throws Exception {
        TarEntry e;
        int count = 0;
        long size = 0L;
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(args[0]);
        IContentPartDao2 contentPartDao = (IContentPartDao2)context.getBean("contentPartDao");
        TarInputStream tis = new TarInputStream((InputStream)new GZIPInputStream(new FileInputStream(args[1])));
        long startingTime = System.currentTimeMillis();
        while ((e = tis.getNextEntry()) != null) {
            if (!e.isDirectory()) {
                ChunkWriterPerformanceTest.savePart(contentPartDao, e.getName(), (InputStream)tis, Integer.parseInt(args[2]));
                size += e.getSize();
                ++count;
            }
            if (count % 50 != 0) continue;
            System.out.println("So far" + count + " objects, " + (long)(count * 1000) / (System.currentTimeMillis() - startingTime) + " objs/s");
            System.out.println("So far" + size + " MB, " + size / (System.currentTimeMillis() - startingTime) + " kB/s");
        }
        System.out.println("So far" + count + " objects, " + (long)(count * 1000) / (System.currentTimeMillis() - startingTime) + " objs/s");
        System.out.println("So far" + size + " MB, " + size / (System.currentTimeMillis() - startingTime) + " kB/s");
    }

    protected static String savePart(IContentPartDao2 dao, String id, InputStream is, int chunkSize) throws ServiceException {
        try {
            int size;
            long offset = 0L;
            byte[] buffer = new byte[chunkSize];
            String handler = dao.create(id, "XX", "other");
            while ((size = ChunkWriterPerformanceTest.readBlock(is, buffer)) > 0) {
                dao.write(handler, offset, buffer, 0, size);
                offset += (long)size;
            }
            dao.commit(handler);
        }
        catch (IOException e) {
            throw new DataAccessException((Throwable)e);
        }
        return id;
    }

    protected static int readBlock(InputStream is, byte[] buf) throws IOException {
        int count = 0;
        int off = 0;
        while (off < buf.length) {
            count = is.read(buf, off, buf.length - off);
            if (count < 0) {
                return off;
            }
            off += count;
        }
        return off;
    }
}

