/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.tools;

import java.util.HashSet;
import pl.edu.icm.yadda.service2.YaddaObjectID;
import pl.edu.icm.yadda.service2.exception.ServiceException;
import pl.edu.icm.yadda.service3.ArchiveObjectFacade;
import pl.edu.icm.yadda.service3.archive.IArchiveFacade2;

public class ListArchive {
    protected IArchiveFacade2 archiveFacade;

    protected String buildVersionInfo(YaddaObjectID id) {
        return String.valueOf(id.getBranch()) + "$" + id.getVersion();
    }

    public String getDescription(YaddaObjectID id) throws ServiceException {
        ArchiveObjectFacade current = this.archiveFacade.getObject(id, null, false);
        HashSet<String> previousVersion = new HashSet<String>();
        if (current.getAlternativeId() != null) {
            previousVersion.add(this.buildVersionInfo(current.getAlternativeId()));
        }
        if (Integer.parseInt(current.getId().getVersion()) > 1) {
            YaddaObjectID probablePrevious = new YaddaObjectID(current.getId().getId(), String.valueOf(Integer.parseInt(current.getId().getVersion()) - 1), current.getId().getBranch());
            previousVersion.add(this.buildVersionInfo(probablePrevious));
        }
        String currentVersion = String.valueOf(current.getId().getBranch()) + "$" + current.getId().getVersion();
        StringBuilder sb = new StringBuilder();
        sb.append("id=" + current.getId().getId() + "; ");
        sb.append("currentVersion=" + currentVersion + "; ");
        sb.append("previousVersions=");
        for (String version : previousVersion) {
            sb.append(version);
            sb.append(" ");
        }
        sb.append("; ");
        sb.append("parent");
        return sb.toString();
    }

    public IArchiveFacade2 getArchiveFacade() {
        return this.archiveFacade;
    }

    public void setArchiveFacade(IArchiveFacade2 archiveFacade) {
        this.archiveFacade = archiveFacade;
    }
}

