/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.tools.cli;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import pl.edu.icm.yadda.service2.catalog.CountingIterator;
import pl.edu.icm.yadda.service2.exception.ServiceException;
import pl.edu.icm.yadda.service3.ArchiveObject2Meta;
import pl.edu.icm.yadda.service3.archive.IArchiveFacade2;

public class DeleteObject {
    public static void main(String[] args) {
        Options options = new Options();
        options.addOption("i", true, "identifier of the object");
        options.addOption("c", true, "service context file");
        options.addOption("h", false, "show help");
        GnuParser parser = new GnuParser();
        try {
            CommandLine cli = parser.parse(options, args);
            if (cli.hasOption("h")) {
                DeleteObject.printHelp(options);
                return;
            }
            if (!cli.hasOption("c")) {
                DeleteObject.printHelp(options);
                return;
            }
            FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(cli.getOptionValue("c"));
            try {
                IArchiveFacade2 archiveFacade = (IArchiveFacade2)context.getBean("archiveFacade");
                Date from = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss").parse(cli.getOptionValue("from"));
                Date to = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss").parse(cli.getOptionValue("to"));
                boolean historical = cli.hasOption("historical");
                boolean onlyRoots = !cli.hasOption("r");
                String mergedTags = cli.getOptionValue("t");
                boolean longDescription = cli.hasOption("l");
                String[] tags = mergedTags != null ? StringUtils.split((String)":") : null;
                CountingIterator result = archiveFacade.listObjects(from, to, tags, historical, onlyRoots);
                while (result.hasNext()) {
                    ArchiveObject2Meta item = (ArchiveObject2Meta)result.next();
                    System.out.print(item.getId().getId());
                    if (longDescription) {
                        System.out.print("\t");
                        System.out.print("B=" + item.getId().getBranch() + ";V=" + item.getId().getVersion());
                        System.out.print("\t");
                        System.out.print(item.getType());
                        System.out.print("\t");
                        System.out.print(item.getParentRelationName() != null ? item.getParentRelationName() : "<ROOT>");
                    }
                    System.out.println();
                }
            }
            finally {
                context.close();
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            DeleteObject.printHelp(options);
        }
        catch (java.text.ParseException e) {
            DeleteObject.printHelp(options);
        }
    }

    static void printHelp(Options o) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("list.sh", o);
    }
}

