/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service3.tools.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import pl.edu.icm.yadda.service2.ArchiveContentPartFacade;
import pl.edu.icm.yadda.service2.exception.ServiceException;
import pl.edu.icm.yadda.service3.ArchiveObject2Meta;
import pl.edu.icm.yadda.service3.ArchiveObjectFacade;
import pl.edu.icm.yadda.service3.archive.IArchiveFacade2;

public class FetchPart {
    public static void main(String[] args) {
        Options options = new Options();
        options.addOption("u", true, "URI path of the object");
        options.addOption("p", true, "type of the part to fetch");
        options.addOption("c", true, "service context file");
        options.addOption("h", false, "show help");
        GnuParser parser = new GnuParser();
        try {
            CommandLine cli = parser.parse(options, args);
            if (cli.hasOption("h")) {
                FetchPart.printHelp(options);
                return;
            }
            if (!(cli.hasOption("c") || cli.hasOption("u") || cli.hasOption("c"))) {
                FetchPart.printHelp(options);
                return;
            }
            FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(cli.getOptionValue("c"));
            try {
                IArchiveFacade2 archiveFacade = (IArchiveFacade2)context.getBean("archiveFacade");
                String path = cli.getOptionValue("u");
                String part = cli.getOptionValue("p");
                ArchiveObject2Meta object = archiveFacade.queryUniqueObject(path, true);
                ArchiveObjectFacade objectFacade = archiveFacade.getObject(object.getId(), new String[]{part}, false);
                ArchiveContentPartFacade partFacade = objectFacade.getPart(part);
                IOUtils.copy((InputStream)partFacade.getData(), (OutputStream)System.out);
            }
            finally {
                context.close();
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            FetchPart.printHelp(options);
        }
    }

    static void printHelp(Options o) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("fetch.sh", o);
    }
}

