----
-- Archive sql init script for PostgreSQL (without joins)
----

CREATE SEQUENCE /*TABLE_PREFIX*/archive__id_seq;

---
-- Common metadata
---

CREATE TABLE /*TABLE_PREFIX*/archive_object (
    _pk BIGINT PRIMARY KEY DEFAULT nextval(/*TABLE_PREFIX*/'archive__id_seq'),
    id VARCHAR NOT NULL,
    version VARCHAR NOT NULL,
    branch VARCHAR NOT NULL,
	history BOOLEAN NOT NULL DEFAULT false,
    display_name VARCHAR,
    object_timestamp TIMESTAMP NOT NULL,
    status VARCHAR NOT NULL,
    object_type VARCHAR NOT NULL,
    alt_id VARCHAR,
    alt_branch VARCHAR,
    alt_version VARCHAR, 
    alt_display_name VARCHAR,           
    parent__pk BIGINT REFERENCES /*TABLE_PREFIX*/archive_object(_pk),
    parent_id VARCHAR,
    parent_version VARCHAR,
	parent_branch VARCHAR,
	parent_display_name VARCHAR,
	parent_relation_name VARCHAR,
	parent_position INTEGER,
    schema_type VARCHAR        
);

-- TODO Create contraint for the parent relations

---
-- Tags
---

CREATE TABLE /*TABLE_PREFIX*/archive_tag (
    owner__pk BIGINT REFERENCES /*TABLE_PREFIX*/archive_object(_pk),
    tag_value VARCHAR,
    PRIMARY KEY(owner__pk, tag_value)
);

CREATE INDEX /*TABLE_PREFIX*/idx_archive_tag_owner__pk ON /*TABLE_PREFIX*/archive_tag (owner__pk);

---
-- Content parts
---

CREATE TABLE /*TABLE_PREFIX*/archive_content_part (
    id VARCHAR NOT NULL PRIMARY KEY,
    parent__id BIGINT REFERENCES /*TABLE_PREFIX*/archive_object(_pk),
    size INT4,
    path VARCHAR,
	direct_content BYTEA,
    data_type VARCHAR,
	mime VARCHAR,
	md5 VARCHAR
);

CREATE TABLE /*TABLE_PREFIX*/archive_empty_file (
	path VARCHAR NOT NULL PRIMARY KEY
);

CREATE TABLE /*TABLE_PREFIX*/archive_index (
	path VARCHAR(1024) NOT NULL,
	pk BIGINT NOT NULL,
	deleted BOOLEAN NOT NULL,
	PRIMARY KEY (path, pk)
);

CREATE UNIQUE INDEX /*TABLE_PREFIX*/idx_archive_object_ivb ON /*TABLE_PREFIX*/archive_object(id, version, branch);

CREATE INDEX /*TABLE_PREFIX*/idx_archive_index_path ON /*TABLE_PREFIX*/archive_index USING btree(path);

CREATE INDEX /*TABLE_PREFIX*/idx_archive_index_pk ON /*TABLE_PREFIX*/archive_index USING btree(pk);

CREATE INDEX /*TABLE_PREFIX*/idx_archive_part__id ON /*TABLE_PREFIX*/archive_content_part USING btree(parent__id);

CREATE INDEX /*TABLE_PREFIX*/idx_archive_object_parent ON /*TABLE_PREFIX*/archive_object USING btree(parent__pk, parent_relation_name);

 create index /*TABLE_PREFIX*/idx_archive_content_part_path ON /*TABLE_PREFIX*/archive_content_part (path);