/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.html;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import net.matuschek.html.FormHandler;
import net.matuschek.http.ExtendedURL;
import org.apache.log4j.Category;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FormFiller {
    private Vector formHandlers = null;
    private Category log = Category.getInstance((String)this.getClass().getName());

    public FormFiller() {
    }

    public FormFiller(Vector formHandler) {
        this();
        this.formHandlers = formHandler;
    }

    public void setFormHandlers(Vector formHandlers) {
        this.formHandlers = formHandlers;
    }

    public Vector getFormHandlers() {
        return this.formHandlers;
    }

    public ExtendedURL fillForm(URL baseURL, Element form) {
        ExtendedURL eurl = new ExtendedURL();
        String formURL = form.getAttribute("action");
        String type = form.getAttribute("method");
        URL absoluteFormURL = null;
        try {
            absoluteFormURL = new URL(baseURL, formURL);
        }
        catch (MalformedURLException e) {
            this.log.info((Object)("MalformedURLException in fillForm(): " + e.getMessage()));
        }
        if (!form.getNodeName().equals("form")) {
            this.log.error((Object)"not a form !");
            return null;
        }
        FormHandler handler = this.getFormHandler(absoluteFormURL.toString());
        if (handler == null) {
            this.log.debug((Object)("found no form handler for URL " + formURL));
            return null;
        }
        if (type.equalsIgnoreCase("get")) {
            eurl.setRequestMethod(1);
        } else if (type.equalsIgnoreCase("post")) {
            eurl.setRequestMethod(2);
        } else if (type.equals("")) {
            eurl.setRequestMethod(1);
        } else {
            this.log.debug((Object)("method " + type + " unknown"));
            return null;
        }
        try {
            eurl.setURL(absoluteFormURL);
        }
        catch (Exception e) {
            this.log.debug((Object)("error calculating URL: " + e.getMessage()));
        }
        handler.clearValues();
        this.collectInputFields(form, handler);
        eurl.setParams(handler.getParamString());
        return eurl;
    }

    private void collectInputFields(Element element, FormHandler fh) {
        if (element == null) {
            this.log.error((Object)"got a null element");
            return;
        }
        if (element.getNodeName().equals("input")) {
            String type = element.getAttribute("type").toLowerCase();
            String name = element.getAttribute("name");
            String value = element.getAttribute("value");
            if (!(type.equals("reset") || name == null || name.equals("") || value == null || value.equals(""))) {
                fh.addValue(name, value);
            }
        }
        NodeList childs = element.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            if (!(childs.item(i) instanceof Element)) continue;
            this.collectInputFields((Element)childs.item(i), fh);
        }
    }

    protected FormHandler getFormHandler(String url) {
        if (url == null) {
            return null;
        }
        if (this.formHandlers == null) {
            return null;
        }
        for (int i = 0; i < this.formHandlers.size(); ++i) {
            FormHandler fh = (FormHandler)this.formHandlers.elementAt(i);
            if (!fh.getUrl().toString().equals(url)) continue;
            return fh;
        }
        return null;
    }
}

