/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.http;

public class DownloadRule {
    private static final int MINDEFAULT = 0;
    private static final int MAXDEFAULT = Integer.MAX_VALUE;
    private String mimeBaseType = null;
    private String mimeSubType = null;
    private int minSize = 0;
    private int maxSize = Integer.MAX_VALUE;
    private boolean allow;
    private boolean processAllowed = true;

    public int getMinSize() {
        return this.minSize;
    }

    public void setMinSize(int minSize) {
        if (minSize >= 0) {
            this.minSize = minSize;
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize >= 0) {
            this.maxSize = maxSize;
        }
    }

    public boolean getAllow() {
        return this.allow;
    }

    public void setAllow(boolean allow) {
        this.allow = allow;
    }

    public boolean getProcessAllowed() {
        return this.processAllowed && this.allow;
    }

    public void setProcessAllowed(boolean processAllowed) {
        this.processAllowed = processAllowed;
    }

    public String getMimeBaseType() {
        return this.mimeBaseType;
    }

    public void setMimeBaseType(String mimeBaseType) {
        this.mimeBaseType = mimeBaseType;
    }

    public String getMimeSubType() {
        return this.mimeSubType;
    }

    public void setMimeSubType(String mimeSubType) {
        this.mimeSubType = mimeSubType;
    }

    public String getMimeType() {
        return this.mimeBaseType + "/" + this.mimeSubType;
    }

    public void setMimeType(String mimeType) throws IllegalArgumentException {
        int pos = mimeType.indexOf("/");
        if (pos < 0) {
            throw new IllegalArgumentException("mime type must be in the format  basetype/subtype");
        }
        this.mimeBaseType = mimeType.substring(0, pos);
        this.mimeSubType = mimeType.substring(pos + 1);
    }

    public boolean matches(String mimeBaseType, String mimeSubType, int size) {
        if (this.simpleStringMatch(mimeBaseType, this.mimeBaseType) && this.simpleStringMatch(mimeSubType, this.mimeSubType)) {
            if (size >= 0) {
                if (size >= this.minSize && size <= this.maxSize) {
                    return true;
                }
            } else {
                return this.minSize == 0 && this.maxSize == Integer.MAX_VALUE;
            }
        }
        return false;
    }

    protected boolean simpleStringMatch(String value, String rule) {
        if (rule.equals("*")) {
            return true;
        }
        return value.equalsIgnoreCase(rule);
    }

    public String toString() {
        String s = null;
        s = this.allow ? "allow" : "deny";
        return this.mimeBaseType + "/" + this.mimeSubType + " >" + this.minSize + " <" + this.maxSize + " " + s;
    }
}

