/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.http;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import net.matuschek.http.DownloadRule;
import net.matuschek.http.HttpHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadRuleSet {
    protected Vector<DownloadRule> rules = new Vector();
    protected boolean defaultBehavior = true;

    public DownloadRuleSet() {
    }

    public DownloadRuleSet(String filename) throws IOException {
        this();
        this.loadRuleFile(filename);
    }

    public void loadRuleFile(String filename) throws IOException {
        FileInputStream is = new FileInputStream(filename);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = "";
        int lineno = 0;
        while (line != null) {
            line = reader.readLine();
            ++lineno;
            if (line == null || line.trim().equals("") || line.startsWith("#")) continue;
            StringTokenizer st = new StringTokenizer(line);
            if (st.countTokens() < 2) {
                throw new IOException("line " + lineno + " has less then 2 fields");
            }
            String allowStr = st.nextToken();
            boolean allow = true;
            String mime = st.nextToken();
            if (allowStr.equalsIgnoreCase("allow")) {
                allow = true;
            } else if (allowStr.equalsIgnoreCase("deny")) {
                allow = false;
            } else {
                throw new IOException("first token in line " + lineno + " has to be allow or deny");
            }
            DownloadRule r = new DownloadRule();
            r.setAllow(allow);
            try {
                r.setMimeType(mime);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e.getMessage());
            }
            while (st.hasMoreTokens()) {
                boolean isMin = true;
                String descr = st.nextToken();
                if (descr.startsWith("<")) {
                    isMin = false;
                } else if (descr.startsWith(">")) {
                    isMin = true;
                } else {
                    throw new IOException("can't understand " + descr + " in line " + lineno);
                }
                int size = 0;
                try {
                    size = Integer.parseInt(descr.substring(1));
                }
                catch (NumberFormatException e) {
                    throw new IOException("no numerical value " + descr + " in line " + lineno);
                }
                if (isMin) {
                    r.setMinSize(size);
                    continue;
                }
                r.setMaxSize(size);
            }
            this.rules.add(r);
        }
    }

    public void setDefault(boolean allow) {
        this.defaultBehavior = allow;
    }

    public boolean getDefault() {
        return this.defaultBehavior;
    }

    public Vector getDownloadRules() {
        return this.rules;
    }

    public void setDownloadRules(Vector<DownloadRule> downloadRules) {
        this.rules = downloadRules;
    }

    public void addRule(String mimeBaseType, String mimeSubtype, int minSize, int maxSize, boolean allow) {
        DownloadRule newrule = new DownloadRule();
        newrule.setMimeBaseType(mimeBaseType);
        newrule.setMimeSubType(mimeSubtype);
        newrule.setMinSize(minSize);
        newrule.setMaxSize(maxSize);
        newrule.setAllow(allow);
        this.rules.add(newrule);
    }

    private DownloadRule findRule(String mimeType, int size) {
        if (mimeType.indexOf("/") < 0) {
            return null;
        }
        if (mimeType.indexOf(";") > 0) {
            StringTokenizer st = new StringTokenizer(mimeType, ";");
            mimeType = st.nextToken();
        }
        String basetype = null;
        String subtype = null;
        StringTokenizer st = new StringTokenizer(mimeType, "/");
        basetype = st.nextToken();
        subtype = st.nextToken();
        for (int i = 0; i < this.rules.size(); ++i) {
            DownloadRule rule = this.rules.elementAt(i);
            if (!rule.matches(basetype, subtype, size)) continue;
            return rule;
        }
        return null;
    }

    protected String getHeaderValue(Vector httpHeaders, String name) {
        for (int i = 0; i < httpHeaders.size(); ++i) {
            HttpHeader h = (HttpHeader)httpHeaders.elementAt(i);
            if (!h.getName().equalsIgnoreCase(name)) continue;
            return h.getValue();
        }
        return null;
    }

    public boolean downloadAllowed(Vector httpHeaders) {
        String mimeType = this.getHeaderValue(httpHeaders, "Content-Type");
        String sizeStr = this.getHeaderValue(httpHeaders, "Content-Length");
        if (mimeType == null) {
            return false;
        }
        int size = -1;
        try {
            size = Integer.parseInt(sizeStr);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        DownloadRule r = this.findRule(mimeType, size);
        if (r == null) {
            return this.defaultBehavior;
        }
        return r.getAllow();
    }

    public boolean processAllowed(Vector httpHeaders) {
        String mimeType = this.getHeaderValue(httpHeaders, "Content-Type");
        String sizeStr = this.getHeaderValue(httpHeaders, "Content-Length");
        if (mimeType == null) {
            return false;
        }
        int size = -1;
        try {
            size = Integer.parseInt(sizeStr);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        DownloadRule r = this.findRule(mimeType, size);
        if (r == null) {
            return this.defaultBehavior;
        }
        return r.getProcessAllowed();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DownloadRule default=");
        if (this.defaultBehavior) {
            sb.append("true");
        } else {
            sb.append("false");
        }
        sb.append("\n");
        for (int i = 0; i < this.rules.size(); ++i) {
            sb.append(" ");
            sb.append(this.rules.elementAt(i).toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

