/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.http;

import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import net.matuschek.http.HTTPDateTool;
import net.matuschek.http.HttpHeader;
import net.matuschek.util.MD5;

public class HttpDoc {
    private byte[] content;
    private Vector<HttpHeader> httpHeader = new Vector();
    private List links;
    private int httpReturnCode = 0;
    private URL url;
    private boolean cached = false;
    private static final int HTTP_REDIRECTSTART = 300;
    private static final int HTTP_REDIRECTEND = 399;

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
        this.removeHeader("Content-MD5");
    }

    public void setHttpCode(String httpCode) {
        StringTokenizer st = new StringTokenizer(httpCode, " ");
        if (st.countTokens() < 2) {
            return;
        }
        st.nextToken();
        String codeStr = st.nextToken();
        try {
            this.httpReturnCode = Integer.parseInt(codeStr);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    public void setHttpCode(int code) {
        this.httpReturnCode = code;
    }

    public int getHttpCode() {
        return this.httpReturnCode;
    }

    public void addHeader(HttpHeader header) {
        this.httpHeader.add(header);
    }

    public Vector getHttpHeader() {
        return this.httpHeader;
    }

    public HttpHeader getHttpHeader(String headerName) {
        for (HttpHeader header : this.httpHeader) {
            if (!header.getName().equals(headerName)) continue;
            return header;
        }
        return null;
    }

    public String getHeaderValue(String headerName) {
        HttpHeader header = this.getHeader(headerName);
        return header != null ? header.getValue() : null;
    }

    public void setHeaderValue(String headerName, String headerValue) {
        HttpHeader header = this.getHeader(headerName);
        if (header == null) {
            header = new HttpHeader(headerName, headerValue);
            this.addHeader(header);
        } else {
            header.setValue(headerValue);
        }
    }

    public String getLocation() {
        HttpHeader location = this.getHeader("location");
        if (location == null) {
            return "";
        }
        return location.getValue();
    }

    public boolean isRedirect() {
        return this.httpReturnCode >= 300 && this.httpReturnCode <= 399;
    }

    public boolean isOk() {
        return this.httpReturnCode == 200;
    }

    public boolean isNotModified() {
        return this.getHttpCode() == 304;
    }

    public boolean isNotFound() {
        return this.httpReturnCode == 404;
    }

    public boolean isUnauthorized() {
        return this.httpReturnCode == 401;
    }

    public HttpHeader getHeader(String name) {
        for (int i = 0; i < this.httpHeader.size(); ++i) {
            HttpHeader h = this.httpHeader.elementAt(i);
            if (!name.equalsIgnoreCase(h.getName())) continue;
            return h;
        }
        return null;
    }

    public HttpHeader removeHeader(String name) {
        HttpHeader header = this.getHeader(name);
        if (header != null) {
            this.httpHeader.remove(header);
        }
        return header;
    }

    public Vector getHttpHeaders() {
        return this.httpHeader;
    }

    public boolean isHTML() {
        HttpHeader ct = this.getHeader("Content-Type");
        if (ct == null) {
            return false;
        }
        return ct.getValue().toLowerCase().startsWith("text/html");
    }

    public boolean isJavaScript() {
        HttpHeader ct = this.getHeader("Content-Type");
        if (ct == null) {
            return false;
        }
        return ct.getValue().equalsIgnoreCase("text/x-javascript");
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append(this.url.toString() + "\n\n");
        for (int i = 0; i < this.httpHeader.size(); ++i) {
            HttpHeader h = this.httpHeader.elementAt(i);
            res.append(h.toString());
            res.append("\n");
        }
        res.append("\n");
        if (this.content != null) {
            res.append(new String(this.content));
        }
        return res.toString();
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public long getLastModifiedAsMilliSeconds() {
        String value = this.getHeaderValue("Last-Modified");
        return value != null ? HTTPDateTool.parseDate(value) : -1L;
    }

    public long getDateAsMilliSeconds() {
        String value = this.getHeaderValue("Date");
        return value != null ? HTTPDateTool.parseDate(value) : -1L;
    }

    public void setLastModified(long d) {
        String dateString = HTTPDateTool.rfc1123Format.format(new Date(d));
        this.setHeaderValue("Last-Modified", dateString);
    }

    public void setDate(long d) {
        String dateString = HTTPDateTool.rfc1123Format.format(new Date(d));
        this.setHeaderValue("Date", dateString);
    }

    protected static String getContentMD5(byte[] content) {
        if (content == null || content.length == 0) {
            return "00000000000000000000000000000000";
        }
        MD5 md5 = new MD5();
        md5.Update(content);
        return md5.asHex();
    }

    public String getContentMD5() {
        String md5;
        HttpHeader md5Header = this.getHeader("Content-MD5");
        if (md5Header != null) {
            md5 = md5Header.getValue();
        } else {
            md5 = HttpDoc.getContentMD5(this.getContent());
            md5Header = new HttpHeader("Content-MD5", md5);
            this.addHeader(md5Header);
        }
        return md5;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setLinks(List links) {
        this.links = links;
    }

    public List getLinks() {
        return this.links;
    }
}

