/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.http;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.matuschek.http.DocManagerException;
import net.matuschek.http.HttpDoc;
import net.matuschek.http.HttpDocManager;
import net.matuschek.http.HttpHeader;
import net.matuschek.util.MD5;
import org.apache.log4j.Category;

public class HttpDocCache
implements HttpDocManager {
    protected static final String CONTENT_DUPLICATE = "Content-Duplicate";
    public boolean useMD5 = true;
    protected static Category log = Category.getInstance((String)HttpDocCache.class.getName());
    private Collection urls = new LinkedList();
    protected String storagedir;
    protected File storageDirectoryFile = null;
    protected static final String LINKS = "links" + File.separator;
    protected static final String CONTENT = "content" + File.separator;
    protected static final String DOCUMENTS = "documents" + File.separator;
    private FileOutputStream storageDirectoryStream = null;
    static final String QUOTE = "\"";
    static final String LF = System.getProperty("line.separator");
    protected int storageDirDepth = 0;

    public HttpDocCache(String storageDirectory) {
        this.setStorageDir(storageDirectory);
    }

    private void setStorageDir(String newStoragedir) {
        File contentFile;
        File storagedirFile;
        this.storagedir = newStoragedir;
        if (!this.storagedir.endsWith(File.separator)) {
            this.storagedir = this.storagedir + File.separator;
        }
        if (!(storagedirFile = new File(this.storagedir + DOCUMENTS)).exists()) {
            storagedirFile.mkdirs();
        }
        if (!(contentFile = new File(this.storagedir + CONTENT)).exists()) {
            contentFile.mkdirs();
        }
        if (this.useMD5) {
            this.storageDirectoryFile = new File(this.storagedir + "directory.csv");
            try {
                this.storageDirectoryStream = new FileOutputStream(this.storageDirectoryFile.getPath(), true);
                if (!this.storageDirectoryFile.exists()) {
                    this.storageDirectoryStream.write(("Path,URL" + LF).getBytes());
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeDocument(HttpDoc doc) throws DocManagerException {
        block9: {
            List links = doc.getLinks();
            if (doc.isCached()) {
                return;
            }
            String filename = this.generateFilename(doc.getURL().toExternalForm());
            String filepath = this.storagedir + DOCUMENTS + filename;
            this.checkStoragePathFor(DOCUMENTS, filename);
            try {
                ZipOutputStream zos;
                BufferedOutputStream fs;
                File f;
                block8: {
                    f = new File(filepath + ".zip");
                    if (!f.exists()) {
                        this.writeDirectoryInfo(doc, filename);
                    }
                    fs = new BufferedOutputStream(new FileOutputStream(f));
                    zos = new ZipOutputStream(fs);
                    zos.setLevel(9);
                    try {
                        this.storeContent(doc);
                        this.writeHeadersToZipFile(doc, zos);
                        this.writeUrlToZipFile(doc, zos);
                        if (links == null) break block8;
                        this.writeLinksToZipFile(links, zos);
                    }
                    catch (Throwable e) {
                        try {
                            System.out.println(e);
                        }
                        catch (Throwable throwable) {
                            zos.close();
                            ((OutputStream)fs).close();
                            long date = doc.getDateAsMilliSeconds();
                            f.setLastModified(date > 0L ? date : System.currentTimeMillis());
                            throw throwable;
                        }
                        zos.close();
                        ((OutputStream)fs).close();
                        long date = doc.getDateAsMilliSeconds();
                        f.setLastModified(date > 0L ? date : System.currentTimeMillis());
                        break block9;
                    }
                }
                zos.close();
                ((OutputStream)fs).close();
                long date = doc.getDateAsMilliSeconds();
                f.setLastModified(date > 0L ? date : System.currentTimeMillis());
            }
            catch (IOException ioex) {
                DocManagerException ex = new DocManagerException(ioex.getMessage());
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDirectoryInfo(HttpDoc doc, String filename) throws IOException {
        if (this.storageDirectoryFile != null) {
            File file = this.storageDirectoryFile;
            synchronized (file) {
                try {
                    String directoryInfo = QUOTE + filename + QUOTE + "," + QUOTE + doc.getURL() + QUOTE + LF;
                    this.storageDirectoryStream.write(directoryInfo.getBytes());
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage());
                    this.storageDirectoryStream.close();
                }
            }
        }
    }

    protected void writeContentToZipFile(HttpDoc doc, ZipOutputStream zos) throws IOException {
        String contenttype = doc.getHeaderValue("Content-Type");
        String extension = this.getExtensionFromContenttype(contenttype);
        ZipEntry zipEntry = new ZipEntry("content" + extension);
        long date = doc.getLastModifiedAsMilliSeconds();
        if (date < 0L) {
            date = doc.getDateAsMilliSeconds();
        }
        zipEntry.setTime(date);
        zos.putNextEntry(zipEntry);
        zos.write(doc.getContent());
        zos.closeEntry();
    }

    protected ZipEntry writeHeadersToZipFile(HttpDoc doc, ZipOutputStream zos) throws IOException {
        StringBuffer comment = new StringBuffer();
        Vector headers = doc.getHttpHeader();
        Iterator iter = headers.iterator();
        while (iter.hasNext()) {
            HttpHeader header = (HttpHeader)iter.next();
            if (header.getName().equals(CONTENT_DUPLICATE)) continue;
            comment.append(header.toString());
            if (!iter.hasNext()) continue;
            comment.append(LF);
        }
        ZipEntry ze = new ZipEntry("header");
        zos.putNextEntry(ze);
        zos.write(comment.toString().getBytes());
        long date = doc.getDateAsMilliSeconds();
        ze.setTime(date > 0L ? date : System.currentTimeMillis());
        zos.closeEntry();
        return ze;
    }

    protected boolean readHeadersFromZipFile(HttpDoc doc, ZipFile zf) throws IOException {
        ZipEntry ze = zf.getEntry("header");
        if (ze != null) {
            InputStream is = zf.getInputStream(ze);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while (reader.ready()) {
                String line = reader.readLine();
                int pos = line.indexOf(": ");
                if (pos < 0) continue;
                String name = line.substring(0, pos);
                String value = line.substring(pos + 2);
                HttpHeader header = new HttpHeader(name, value);
                doc.addHeader(header);
            }
            reader.close();
            return true;
        }
        return false;
    }

    protected boolean readLinksFromZipFile(HttpDoc doc, ZipFile zf) throws IOException {
        ZipEntry ze = zf.getEntry("links");
        Vector<URL> links = doc.getLinks();
        if (links == null) {
            links = new Vector<URL>();
            doc.setLinks(links);
        } else {
            links.clear();
        }
        if (ze != null) {
            InputStream is = zf.getInputStream(ze);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while (reader.ready()) {
                String line = reader.readLine();
                if (line == null) continue;
                URL url = new URL(line);
                links.add(url);
            }
            reader.close();
            return true;
        }
        return false;
    }

    protected ZipEntry writeUrlToZipFile(HttpDoc doc, ZipOutputStream zos) throws IOException {
        String url = doc.getURL().toString();
        ZipEntry ze = new ZipEntry("url");
        zos.putNextEntry(ze);
        zos.write(url.getBytes());
        long date = doc.getDateAsMilliSeconds();
        ze.setTime(date > 0L ? date : System.currentTimeMillis());
        zos.closeEntry();
        return ze;
    }

    private File getContentUsersFile(HttpDoc doc) {
        File f = null;
        byte[] content = doc.getContent();
        if (content.length != 0) {
            String md5 = doc.getContentMD5();
            f = this.contentFile(md5, ".txt");
        }
        return f;
    }

    public String findDuplicate(HttpDoc doc) throws IOException {
        String duplicate = null;
        File f = this.getContentUsersFile(doc);
        if (f != null) {
            String urlString = doc.getURL().toString();
            if (f.exists()) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                while (reader.ready() && !(line = reader.readLine()).equals(urlString)) {
                    if (duplicate != null) continue;
                    duplicate = line;
                }
                reader.close();
            }
        }
        return duplicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeContent(HttpDoc doc) throws IOException {
        File fzip;
        if (doc.getContent().length == 0) {
            return;
        }
        File f = this.getContentUsersFile(doc);
        String urlString = doc.getURL().toString();
        String md5 = doc.getContentMD5();
        boolean found = false;
        if (f.exists()) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            try {
                while (reader.ready()) {
                    String line = reader.readLine();
                    if (!line.equals(urlString)) continue;
                    found = true;
                    break;
                }
            }
            finally {
                reader.close();
            }
        }
        if (!(fzip = this.contentFile(md5, ".zip")).exists()) {
            this.checkStoragePathFor(CONTENT, this.useFirstCharactersAsDirectories(md5));
            BufferedOutputStream fs = new BufferedOutputStream(new FileOutputStream(fzip));
            ZipOutputStream zos = null;
            try {
                zos = new ZipOutputStream(fs);
                zos.setLevel(9);
                this.writeContentToZipFile(doc, zos);
            }
            finally {
                if (zos != null) {
                    zos.close();
                } else {
                    ((OutputStream)fs).close();
                }
            }
        } else {
            fzip.setLastModified(System.currentTimeMillis());
        }
        if (!found) {
            FileOutputStream os = new FileOutputStream(f.getPath(), true);
            try {
                os.write((urlString + LF).getBytes());
            }
            finally {
                os.close();
            }
        }
    }

    protected void writeLinksToZipFile(List links, ZipOutputStream zs) throws IOException {
        HashSet<URL> storedLinks = new HashSet<URL>();
        ZipEntry zipEntry = new ZipEntry("links");
        zs.putNextEntry(zipEntry);
        for (URL url : links) {
            if (storedLinks.contains(url)) continue;
            zs.write((url.toString() + LF).getBytes());
            storedLinks.add(url);
        }
        zs.closeEntry();
    }

    public void processDocument(HttpDoc doc) throws DocManagerException {
        log.info((Object)("Processing " + doc.getURL().toExternalForm() + doc.getHttpHeader()));
        HttpHeader duplicate = doc.getHeader(CONTENT_DUPLICATE);
        if (duplicate == null) {
            this.urls.add(doc.getURL());
        }
    }

    public HttpDoc retrieveFromCache(URL url) {
        HttpDoc doc = null;
        File f = null;
        try {
            String filename0 = url.toExternalForm();
            String filename = this.generateFilename(filename0) + ".zip";
            f = new File(this.storagedir + DOCUMENTS + filename);
            if (f.exists()) {
                log.info((Object)("retrieve " + f));
                doc = new HttpDoc();
                doc.setURL(url);
                ZipFile zf = new ZipFile(f);
                this.readHeadersFromZipFile(doc, zf);
                this.readLinksFromZipFile(doc, zf);
                doc.setCached(true);
                String md5 = doc.getContentMD5();
                File contentFile = this.contentFile(md5, ".zip");
                if (contentFile.exists()) {
                    ZipFile contentZip = new ZipFile(contentFile);
                    this.readContentFromZipFile(doc, contentZip);
                    contentZip.close();
                } else {
                    doc.setContent(new byte[0]);
                }
                zf.close();
            }
        }
        catch (Exception e) {
            log.warn((Object)("removing invalid file " + f));
            f.delete();
            doc = null;
        }
        return doc;
    }

    protected void readContentFromZipFile(HttpDoc doc, ZipFile contentZip) throws IOException {
        byte[] content = null;
        Enumeration<? extends ZipEntry> enumeration = contentZip.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().startsWith("content")) continue;
            InputStream is = contentZip.getInputStream(zipEntry);
            int length = (int)zipEntry.getSize();
            content = new byte[length];
            for (int startPos = 0; startPos < length; startPos += is.read(content, startPos, length - startPos)) {
            }
            is.close();
            break;
        }
        doc.setContent(content);
    }

    public void removeDocument(URL url) {
        HttpDoc doc = this.retrieveFromCache(url);
        File f = null;
        try {
            String filename0 = url.toExternalForm();
            String filename = this.generateFilename(filename0) + ".zip";
            f = new File(this.storagedir + LINKS + filename);
            if (f.exists()) {
                f.delete();
            }
            this.deleteContent(doc);
            f = new File(this.storagedir + DOCUMENTS + filename);
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    private void deleteContent(HttpDoc doc) throws IOException {
        byte[] content = doc.getContent();
        if (content.length == 0) {
            return;
        }
        String urlString = doc.getURL().toString();
        String md5 = doc.getContentMD5();
        File f = this.contentFile(md5, ".txt");
        ArrayList<String> entries = new ArrayList<String>();
        if (f.exists()) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while (reader.ready()) {
                String line = reader.readLine();
                if (line.equals(urlString)) continue;
                entries.add(line);
            }
            reader.close();
        }
        if (entries.size() > 0) {
            FileOutputStream os = new FileOutputStream(f.getPath(), false);
            for (String line : entries) {
                os.write((line + LF).getBytes());
            }
            os.close();
        } else {
            f.delete();
            File fzip = this.contentFile(md5, ".zip");
            if (fzip.exists()) {
                fzip.delete();
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        Iterator i = this.urls.iterator();
        while (i.hasNext()) {
            sb.append(i.next()).append("\n");
        }
        return sb.toString();
    }

    private final String useFirstCharactersAsDirectories(String filename) {
        int n = this.storageDirDepth;
        if (n > filename.length()) {
            n = filename.length();
        }
        char[] dir = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            dir[i * 2] = filename.charAt(i);
            dir[i * 2 + 1] = File.separatorChar;
        }
        return new String(dir);
    }

    private final void checkStoragePathFor(String subdirectory, String filename) {
        if (!subdirectory.endsWith(File.separator)) {
            subdirectory = subdirectory + File.separator;
        }
        String head = filename.substring(0, this.storageDirDepth * 2);
        File path = new File(this.storagedir + subdirectory + head);
        if (!path.exists()) {
            path.mkdirs();
        }
    }

    protected String generateFilename(String docURI) {
        if (this.useMD5) {
            MD5 md5 = new MD5(docURI);
            String hex = md5.asHex();
            if (this.storageDirDepth > 0) {
                return this.useFirstCharactersAsDirectories(hex) + hex.substring(this.storageDirDepth);
            }
            return hex;
        }
        StringBuffer buf = new StringBuffer(docURI.length());
        block11: for (int i = 0; i < docURI.length(); ++i) {
            char c = docURI.charAt(i);
            switch (c) {
                case '/': {
                    buf.append("&slash;");
                    continue block11;
                }
                case '\\': {
                    buf.append("&backslash");
                    continue block11;
                }
                case ':': {
                    buf.append("&colon;");
                    continue block11;
                }
                case '*': {
                    buf.append("&asterisk;");
                    continue block11;
                }
                case '?': {
                    buf.append("&question;");
                    continue block11;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block11;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block11;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block11;
                }
                case '|': {
                    buf.append("&or;");
                    continue block11;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        docURI = buf.toString();
        return docURI;
    }

    protected File contentFile(String hex, String extension) {
        return new File(this.storagedir + CONTENT + this.useFirstCharactersAsDirectories(hex) + hex.substring(this.storageDirDepth) + extension);
    }

    public void finish() {
        if (this.storageDirectoryStream != null) {
            try {
                this.storageDirectoryStream.close();
                this.storageDirectoryStream = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    public void setStorageDirDepth(int depth) {
        this.storageDirDepth = depth;
    }

    public int getStorageDirDepth() {
        return this.storageDirDepth;
    }

    private String getExtensionFromContenttype(String contenttype) {
        String extension = null;
        if (contenttype != null) {
            String strContentType = null;
            int pos = contenttype.indexOf(59);
            strContentType = pos > 0 ? contenttype.substring(0, pos).trim() : contenttype.trim();
            extension = this.getDefaultExtension(strContentType);
        }
        extension = extension == null ? "" : "." + extension;
        return extension;
    }

    protected String getDefaultExtension(String contentType) {
        if (contentType == null) {
            return null;
        }
        if (contentType.indexOf("text/html") >= 0) {
            return ".html";
        }
        if (contentType.indexOf("text/") >= 0) {
            return ".txt";
        }
        return null;
    }
}

