/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.http;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import net.matuschek.http.AbstractHttpDocManager;
import net.matuschek.http.DocManagerException;
import net.matuschek.http.HttpDoc;
import net.matuschek.http.HttpHeader;
import org.apache.log4j.Category;

public class HttpDocToFile
extends AbstractHttpDocManager {
    private String baseDir;
    private int minFileSize;
    private boolean replaceAllSpecials = false;
    private boolean storeCGI = true;
    private Category log;

    public HttpDocToFile(String baseDir) {
        this.baseDir = baseDir;
        this.log = Category.getInstance((String)this.getClass().getName());
    }

    public void storeDocument(HttpDoc doc) throws DocManagerException {
        if (doc == null || doc.getContent() == null) {
            return;
        }
        if (doc.isCached()) {
            return;
        }
        if (!this.storeCGI && doc.getURL().toString().indexOf(63) >= 0) {
            return;
        }
        String filename = this.url2Filename(doc.getURL());
        if (doc.getContent().length >= this.minFileSize) {
            try {
                this.createDirs(filename);
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(filename));
                os.write(doc.getContent());
                os.flush();
                os.close();
            }
            catch (IOException e) {
                throw new DocManagerException(e.getMessage());
            }
        }
    }

    protected File getCacheFile(URL url) {
        File cacheFile = new File(this.url2Filename(url));
        if (!cacheFile.exists() || !cacheFile.isFile()) {
            return null;
        }
        return cacheFile;
    }

    protected String getExtension(URL url) {
        if (url.toString().indexOf(63) >= 0 || url.toString().indexOf("cgi") >= 0) {
            return null;
        }
        String path = url.getPath();
        String ext = null;
        if (path.indexOf(".") < 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, ".");
        while (st.hasMoreTokens()) {
            ext = st.nextToken();
        }
        if (ext.indexOf("/") >= 0) {
            return null;
        }
        return ext;
    }

    public void removeDocument(URL u) {
        String ext = this.getExtension(u);
        if (ext == null) {
            return;
        }
        File cacheFile = this.getCacheFile(u);
        if (cacheFile == null) {
            return;
        }
        cacheFile.delete();
    }

    public HttpDoc retrieveFromCache(URL u) {
        String ext = this.getExtension(u);
        if (ext == null) {
            return null;
        }
        File cacheFile = this.getCacheFile(u);
        if (cacheFile == null) {
            return null;
        }
        long size = cacheFile.length();
        if (size > Integer.MAX_VALUE) {
            this.log.info((Object)"File too large");
            return null;
        }
        byte[] buff = new byte[(int)size];
        try {
            FileInputStream fi = new FileInputStream(cacheFile);
            fi.read(buff);
        }
        catch (IOException e) {
            this.log.info((Object)("Could not read cached document " + e.getMessage()));
            return null;
        }
        HttpDoc doc = new HttpDoc();
        doc.setHttpCode("HTTP/1.0 200 OK");
        doc.setContent(buff);
        String mimetype = null;
        mimetype = ext.equals("html") || ext.equals("htm") || ext.equals("shtml") || ext.equals("asp") || ext.equals("php") || ext.equals("jsp") ? "text/html" : "application/unknown";
        doc.addHeader(new HttpHeader("Content-Type", mimetype));
        doc.setURL(u);
        doc.setCached(true);
        return doc;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    protected String url2Filename(URL u) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.baseDir);
        sb.append(File.separatorChar);
        sb.append(u.getHost());
        sb.append(u.getFile());
        String query = u.getQuery();
        if (query != null && !query.equals("")) {
            sb.append(File.separatorChar);
            sb.append(query);
        }
        if (sb.charAt(sb.length() - 1) == '/') {
            sb.append("index.html");
        }
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            char newc = '\u0000';
            if (c == '/') {
                newc = File.separatorChar;
            }
            if (this.replaceAllSpecials && (c == '?' || c == '=' || c == '&')) {
                newc = '-';
            }
            if (newc == '\u0000' || newc == c) continue;
            sb.setCharAt(i, newc);
        }
        return sb.toString();
    }

    protected void createDirs(String filename) throws IOException {
        int pos = -1;
        for (int i = filename.length() - 1; i >= 0; --i) {
            if (filename.charAt(i) != File.separatorChar) continue;
            pos = i;
            i = -1;
        }
        File dir = new File(filename.substring(0, pos));
        dir.mkdirs();
    }

    public int getMinFileSize() {
        return this.minFileSize;
    }

    public void setMinFileSize(int minFileSize) {
        this.minFileSize = minFileSize;
    }

    public boolean isReplaceAllSpecials() {
        return this.replaceAllSpecials;
    }

    public void setReplaceAllSpecials(boolean v) {
        this.replaceAllSpecials = v;
    }

    public boolean getStoreCGI() {
        return this.storeCGI;
    }

    public void setStoreCGI(boolean v) {
        this.storeCGI = v;
    }
}

