/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.http;

public class HttpHeader {
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String DATE = "Date";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String LOCATION = "location";
    public static final String SERVER = "Server";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String CONTENT_MD5 = "Content-MD5";
    private String name = "";
    private String value = "";

    public HttpHeader(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public HttpHeader(String httpLine) {
        int pos = 0;
        pos = httpLine.indexOf(":");
        if (pos == -1) {
            return;
        }
        this.name = httpLine.substring(0, pos);
        this.value = httpLine.substring(pos + 1).trim();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return this.toLine();
    }

    public String toLine() {
        return this.name + ": " + this.value;
    }

    public boolean isSetCookie() {
        return this.name.equalsIgnoreCase(SET_COOKIE);
    }
}

