/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.http;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import net.matuschek.http.DownloadRuleSet;
import net.matuschek.http.HttpDoc;
import net.matuschek.http.HttpException;
import net.matuschek.http.HttpHeader;
import net.matuschek.http.HttpToolCallback;
import net.matuschek.http.NTLMAuthorization;
import net.matuschek.http.connection.HttpConnection;
import net.matuschek.http.connection.HttpsHelper;
import net.matuschek.http.cookie.Cookie;
import net.matuschek.http.cookie.CookieException;
import net.matuschek.http.cookie.CookieManager;
import net.matuschek.http.cookie.MemoryCookieManager;
import net.matuschek.util.Base64;
import net.matuschek.util.ByteBuffer;
import net.matuschek.util.ChunkedInputStream;
import net.matuschek.util.LimitedBandwidthStream;
import org.apache.log4j.Category;

public class HttpTool {
    static final byte CR = 13;
    static final byte LF = 10;
    static final String HTTP_VERSION = "HTTP/1.1";
    public static final int STATUS_CONNECTING = 0;
    public static final int STATUS_CONNECTED = 1;
    public static final int STATUS_RETRIEVING = 2;
    public static final int STATUS_DONE = 3;
    public static final int STATUS_DENIEDBYRULE = 4;
    private static final int DEFAULT_HTTPPORT = 80;
    private static final int DEFAULT_HTTPSPORT = 443;
    private static final String AGENTNAME = "JoBo/1.4beta (http://www.matuschek.net/jobo.html)";
    private static final int DEFAULT_UPDATEINTERVAL = 1024;
    private static final int DEFAULT_SOCKETTIMEOUT = 20;
    private String agentName = "JoBo/1.4beta (http://www.matuschek.net/jobo.html)";
    private String referer = null;
    private String fromAddress = null;
    private Date modifyDate = null;
    private int bandwidth = 0;
    private InetAddress proxyAddr = null;
    private int proxyPort = 0;
    private String proxyDescr = "";
    private int socketTimeout = 20;
    private boolean cookiesEnabled = true;
    private Category log = null;
    private Properties userInfos = new Properties();
    private int updateInterval = 1024;
    private HttpToolCallback callback = null;
    private DownloadRuleSet downloadRules = null;
    private CookieManager cookieManager = new MemoryCookieManager();
    static SimpleDateFormat df;
    private NTLMAuthorization ntlmAuthorization = null;

    public HttpTool() {
        this.log = Category.getInstance((String)this.getClass().getName());
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public void setAgentName(String name) {
        this.agentName = name;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void finish() {
        if (this.cookieManager != null) {
            this.cookieManager.finish();
        }
    }

    public void setDownloadRuleSet(DownloadRuleSet rules) {
        this.downloadRules = rules;
    }

    public DownloadRuleSet getDownloadRuleSet() {
        return this.downloadRules;
    }

    public int getTimeout() {
        return this.socketTimeout;
    }

    public void setTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public void setEnableCookies(boolean enable) {
        this.cookiesEnabled = enable;
    }

    public boolean getEnableCookies() {
        return this.cookiesEnabled;
    }

    public void setProxy(String proxyDescr) throws HttpException {
        this.proxyAddr = null;
        this.proxyPort = 0;
        String proxyHost = null;
        if (proxyDescr != null && !proxyDescr.equals("")) {
            int pos = proxyDescr.indexOf(":");
            if (pos > 0) {
                try {
                    String port = proxyDescr.substring(pos + 1);
                    proxyHost = proxyDescr.substring(0, pos);
                    this.proxyPort = Integer.parseInt(port);
                    this.proxyAddr = InetAddress.getByName(proxyHost);
                }
                catch (NumberFormatException e) {
                    throw new HttpException("Proxy definition incorrect, port not numeric: " + proxyDescr);
                }
                catch (UnknownHostException e) {
                    throw new HttpException("Host not found: " + proxyHost);
                }
            } else {
                throw new HttpException("Proxy definition incorrect, fomat must be host:port: " + proxyDescr);
            }
        }
        this.proxyDescr = proxyDescr;
    }

    public String getProxy() {
        return this.proxyDescr;
    }

    public void setIfModifiedSince(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    public Date getIfModifiedSince() {
        return this.modifyDate;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public HttpToolCallback getCallback() {
        return this.callback;
    }

    public int getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(int bandwidth) {
        this.bandwidth = bandwidth;
    }

    public void setCallback(HttpToolCallback callback) {
        this.callback = callback;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(int updateInterval) {
        if (updateInterval <= 0) {
            throw new IllegalArgumentException("updateInterval must be > 0 (was " + updateInterval + ")");
        }
        this.updateInterval = updateInterval;
    }

    public void setCookieManager(CookieManager cm) {
        this.cookieManager = cm;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public void clearCookies() {
        if (this.cookieManager != null) {
            this.cookieManager.clear();
        }
    }

    public HttpDoc retrieveDocument(URL u, int method, String parameters) throws HttpException {
        HttpDoc doc;
        DocAndConnection docAndConnection = this.retrieveDocumentInternal(u, method, parameters, null, null);
        HttpDoc httpDoc = doc = docAndConnection != null ? docAndConnection.httpDoc : null;
        if (doc != null && doc.getHttpCode() == 401) {
            String authProtName = "WWW-Authenticate";
            String authProtValue = doc.getHeaderValue(authProtName);
            if (authProtValue == null) {
                authProtName = "Proxy-Authenticate";
                authProtValue = doc.getHeaderValue(authProtName);
            }
            if (authProtValue.indexOf("NTLM") >= 0 || authProtValue.indexOf("Negotiate") >= 0) {
                try {
                    NTLMAuthorization authorization = (NTLMAuthorization)this.ntlmAuthorization.clone();
                    authorization.setHost(u.getHost());
                    String auth = authorization.getRequest();
                    docAndConnection = this.retrieveDocumentInternal(u, method, parameters, null, auth);
                    doc = docAndConnection.httpDoc;
                    authProtValue = doc.getHeaderValue(authProtName);
                    authorization.extractNonce(authProtValue);
                    auth = authorization.getResponse();
                    docAndConnection = this.retrieveDocumentInternal(u, method, parameters, docAndConnection.httpConnection, auth);
                    if (docAndConnection != null) {
                        doc = docAndConnection.httpDoc;
                        if (docAndConnection.httpConnection != null) {
                            docAndConnection.httpConnection.close();
                        }
                    } else {
                        doc = null;
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)("NTLM-Authentication Error: " + e.getMessage()));
                    throw new HttpException(e.getMessage());
                }
            }
        }
        return doc;
    }

    protected DocAndConnection retrieveDocumentInternal(URL u, int method, String parameters, HttpConnection httpConn, String ntlmAuthorizationInfo) throws HttpException {
        String host = null;
        InetAddress addr = null;
        String path = null;
        String requestPath = null;
        String protocol = null;
        String userinfo = null;
        boolean chunkedEncoding = false;
        boolean secureConnection = false;
        ChunkedInputStream chunkStream = null;
        int docSize = -1;
        int port = 0;
        HttpDoc doc = new HttpDoc();
        int i = 0;
        doc.setURL(u);
        ByteBuffer buff = new ByteBuffer();
        LimitedBandwidthStream is = null;
        BufferedWriter bwrite = null;
        host = u.getHost();
        if (host == null) {
            throw new HttpException("no host part in URL found");
        }
        if (!this.useProxy()) {
            try {
                addr = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                addr = null;
            }
            if (addr == null) {
                throw new HttpException("host part (" + host + ") does not resolve");
            }
        }
        if ((path = u.getFile()).equals("")) {
            path = "/";
        }
        path = path.replaceAll(" ", "%20");
        port = u.getPort();
        protocol = u.getProtocol().toLowerCase();
        if (protocol.equals("http")) {
            if (port == -1) {
                port = 80;
            }
        } else if (protocol.equals("https")) {
            if (port == -1) {
                port = 443;
            }
            secureConnection = true;
        } else {
            throw new HttpException("protocol " + protocol + " not supported");
        }
        requestPath = this.useProxy() && !secureConnection ? "http://" + host + path : path;
        userinfo = u.getUserInfo();
        if (userinfo != null) {
            if (userinfo.equals("")) {
                userinfo = null;
            } else {
                this.userInfos.setProperty(host, userinfo);
            }
        } else {
            userinfo = this.userInfos.getProperty(host);
        }
        if (this.callback != null) {
            this.callback.setHttpToolDocUrl(u.toString());
            this.callback.setHttpToolStatus(0);
        }
        try {
            HttpHeader contentLength;
            String cookieString;
            if (httpConn == null) {
                if (secureConnection) {
                    HttpsHelper helper = new HttpsHelper(this.proxyAddr, this.proxyPort, this.useProxy());
                    httpConn = helper.createHttpsConnection(host, port);
                } else {
                    httpConn = this.useProxy() ? HttpConnection.createConnection(this.proxyAddr, this.proxyPort, this.socketTimeout * 1000) : HttpConnection.createConnection(addr, port, this.socketTimeout * 1000);
                }
            }
            is = new LimitedBandwidthStream(new BufferedInputStream(httpConn.getInputStream(), 256), this.bandwidth);
            bwrite = new BufferedWriter(new OutputStreamWriter(httpConn.getOutputStream()));
            if (this.callback != null) {
                this.callback.setHttpToolStatus(1);
            }
            if (method == 1) {
                bwrite.write("GET ");
                bwrite.write(requestPath);
                if (parameters != null && !parameters.equals("")) {
                    bwrite.write("?");
                    bwrite.write(parameters);
                }
            } else if (method == 2) {
                bwrite.write("POST " + requestPath);
            } else {
                throw new HttpException("HTTP method " + method + " not supported");
            }
            bwrite.write(" ");
            bwrite.write(HTTP_VERSION);
            bwrite.write("\r\n");
            if (this.referer != null) {
                bwrite.write("Referer: " + this.referer + "\r\n");
            }
            if (this.cookiesEnabled && (cookieString = this.cookieManager.cookiesForURL(u)) != null) {
                bwrite.write("Cookie: ");
                bwrite.write(cookieString);
                bwrite.write("\r\n");
                this.log.debug((Object)("Cookie request header: " + cookieString));
            }
            bwrite.write("Host: " + host + "\r\n");
            bwrite.write("User-Agent: " + this.agentName + "\r\n");
            bwrite.write("Accept: */*\r\n");
            if (ntlmAuthorizationInfo == null) {
                bwrite.write("Connection: close\r\n");
            } else {
                bwrite.write("Connection: keep-alive\r\n");
            }
            if (this.fromAddress != null) {
                bwrite.write("From: " + this.fromAddress + "\r\n");
            }
            if (userinfo != null) {
                userinfo = userinfo.replace('%', '@');
                bwrite.write("Authorization: Basic ");
                bwrite.write(Base64.encode(userinfo));
                bwrite.write("\r\n");
                this.log.debug((Object)userinfo);
            }
            if (ntlmAuthorizationInfo != null) {
                bwrite.write("Authorization: NTLM ");
                bwrite.write(ntlmAuthorizationInfo);
                bwrite.write("\r\n");
            }
            if (this.modifyDate != null) {
                String dateStr = df.format(this.modifyDate);
                bwrite.write("If-Modified-Since: ");
                bwrite.write(dateStr);
                bwrite.write("\r\n");
                this.log.debug((Object)("If-Modified-Since header: " + dateStr));
            }
            if (method == 2) {
                bwrite.write("Content-Type: application/x-www-form-urlencoded\r\n");
                bwrite.write("Content-Length: " + parameters.length() + "\r\n");
            }
            bwrite.write("\r\n");
            if (method == 2) {
                bwrite.write(parameters);
            }
            bwrite.flush();
            if (this.callback != null) {
                this.callback.setHttpToolStatus(2);
            }
            while ((i = ((InputStream)is).read()) != 10) {
                if (i == -1) {
                    throw new HttpException("Could not get HTTP return code (buffer content is " + buff.toString() + ")");
                }
                buff.append((byte)i);
            }
            String httpCode = this.lineString(buff.getContent());
            buff.clean();
            doc.setHttpCode(httpCode);
            boolean finishedHeaders = false;
            while (!finishedHeaders) {
                i = ((InputStream)is).read();
                if (i == -1) {
                    throw new HttpException("Could not read HTTP headers");
                }
                if (i >= 32) {
                    buff.append((byte)i);
                }
                if (i != 10) continue;
                String line = this.lineString(buff.getContent());
                buff.clean();
                if (line.trim().equals("")) {
                    finishedHeaders = true;
                    continue;
                }
                HttpHeader head = new HttpHeader(line);
                doc.addHeader(head);
                if (this.cookiesEnabled && head.isSetCookie()) {
                    try {
                        Cookie cookie = new Cookie(head.toLine(), u);
                        this.cookieManager.add(cookie);
                        this.log.debug((Object)("Got a cookie " + cookie));
                    }
                    catch (CookieException e) {
                        this.log.info((Object)("Could not interpret cookie: " + e.getMessage()));
                    }
                }
                if (!head.getName().equalsIgnoreCase("Transfer-Encoding") || !head.getValue().equalsIgnoreCase("chunked")) continue;
                chunkedEncoding = true;
            }
            buff.clean();
            if (this.downloadRules != null) {
                HttpHeader lastModifiedHeader;
                boolean isNotModified = false;
                if (this.modifyDate != null && (lastModifiedHeader = doc.getHttpHeader("Last-Modified")) != null) {
                    try {
                        Date lastModifiedDate = df.parse(lastModifiedHeader.getValue());
                        if (lastModifiedDate.compareTo(this.modifyDate) <= 0) {
                            isNotModified = true;
                        }
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                }
                if (!this.downloadRules.downloadAllowed(doc.getHttpHeader()) || isNotModified) {
                    if (doc.isNotModified()) {
                        this.log.info((Object)("If-Not-Modified successfull for: " + u));
                    } else if (isNotModified) {
                        this.log.info((Object)("Header indicates not modified for: " + u));
                    } else {
                        this.log.info((Object)"Download not allowed by download rule.");
                    }
                    httpConn.close();
                    httpConn = null;
                    if (this.callback != null) {
                        this.callback.setHttpToolStatus(4);
                    }
                    return null;
                }
            }
            if (chunkedEncoding) {
                chunkStream = new ChunkedInputStream(is);
            }
            if ((contentLength = doc.getHeader("Content-Length")) != null) {
                try {
                    docSize = Integer.parseInt(contentLength.getValue());
                }
                catch (NumberFormatException e) {
                    this.log.error((Object)"Got a malformed Content-Length header from the server");
                    docSize = -1;
                }
                if (this.callback != null) {
                    this.callback.setHttpToolDocSize(docSize);
                }
                if (docSize > 0) {
                    buff.setSize(docSize);
                }
            }
            boolean finished = false;
            int count = 0;
            while (!finished) {
                i = chunkedEncoding ? chunkStream.read() : ((InputStream)is).read();
                if (i == -1) {
                    finished = true;
                } else {
                    buff.append((byte)i);
                    ++count;
                }
                if (count == docSize) {
                    finished = true;
                }
                if (chunkedEncoding && chunkStream.isDone()) {
                    finished = true;
                }
                if (this.callback == null || buff.length() % this.updateInterval != 0 && !finished) continue;
                this.callback.setHttpToolDocCurrentSize(buff.length());
            }
            doc.setContent(buff.getContent());
            if (ntlmAuthorizationInfo == null) {
                httpConn.close();
                httpConn = null;
            }
            if (this.callback != null) {
                this.callback.setHttpToolStatus(3);
            }
        }
        catch (IOException e) {
            throw new HttpException(e.getMessage());
        }
        DocAndConnection docAndConnection = new DocAndConnection();
        docAndConnection.httpDoc = doc;
        docAndConnection.httpConnection = httpConn;
        return docAndConnection;
    }

    protected boolean useProxy() {
        return this.proxyAddr != null;
    }

    protected String lineString(byte[] b) {
        if (b.length == 0) {
            return "";
        }
        if (b[b.length - 1] != 13) {
            return new String(b);
        }
        return new String(b, 0, b.length - 1);
    }

    public void setNtlmAuthorization(NTLMAuthorization ntlmAuthorization) {
        this.ntlmAuthorization = ntlmAuthorization;
    }

    public NTLMAuthorization getNtlmAuthorization() {
        return this.ntlmAuthorization;
    }

    static {
        TimeZone local = TimeZone.getDefault();
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        TimeZone.setDefault(gmt);
        df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        TimeZone.setDefault(local);
    }

    protected class DocAndConnection {
        HttpDoc httpDoc;
        HttpConnection httpConnection;

        protected DocAndConnection() {
        }
    }
}

