/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.http;

import com.luigidragone.net.ntlm.NTLM;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.security.Provider;
import java.security.Security;
import net.matuschek.util.Base64;

public class NTLMAuthorization
implements Serializable,
Cloneable {
    static final long serialVersionUID = -1347968095010834437L;
    public static final String NTLM_TAG = "NTLM";
    public static final String PROXY_AUTHENTICATE_HEADER = "Proxy-Authenticate";
    public static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    transient byte[] nonce = null;
    private String host = null;
    private String user = null;
    private String hostDomain = null;
    private String userDomain = null;
    private String securityProvider = null;
    private byte[] lmPassword = null;
    private byte[] ntPassword = null;
    private static boolean securityProviderAdded = false;

    public NTLMAuthorization() {
    }

    public NTLMAuthorization(String host, String hostDomain, String user, String userDomain, byte[] lmPassword, byte[] ntPassword) {
        this.setHost(host);
        this.setHostDomain(hostDomain);
        this.setUser(user);
        this.setUserDomain(userDomain);
        this.setLmPasswordHash(lmPassword);
        this.setNtPasswordHash(ntPassword);
    }

    public NTLMAuthorization(String host, String hostDomain, String user, String userDomain, String password) throws MissingJceException {
        this.setHost(host);
        this.setHostDomain(hostDomain);
        this.setUser(user);
        this.setUserDomain(userDomain);
        this.setPassword(password);
    }

    public String getResponse() throws MissingJceException {
        try {
            return new String(Base64.encode(NTLM.formatResponse(this.host, this.user, this.userDomain, this.lmPassword, this.ntPassword, this.nonce)));
        }
        catch (Exception e) {
            throw new MissingJceException(e.getMessage());
        }
    }

    public String getRequest() throws IOException {
        return new String(Base64.encode(NTLM.formatRequest(this.host, this.hostDomain)));
    }

    public void extractNonce(String challenge) throws IOException {
        this.nonce = null;
        try {
            if (challenge != null && challenge.startsWith(NTLM_TAG) && challenge.length() > 4) {
                this.nonce = NTLM.getNonce(Base64.decode(challenge.substring(challenge.indexOf(32) + 1).trim()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setHost(String host) {
        if (host == null) {
            throw new IllegalArgumentException("host : null value not allowed");
        }
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setHostDomain(String hostDomain) {
        if (hostDomain == null) {
            throw new IllegalArgumentException("hostDomain : null value not allowed");
        }
        this.hostDomain = hostDomain;
    }

    public String getHostDomain() {
        return this.hostDomain;
    }

    public void setUser(String user) {
        if (user == null) {
            throw new IllegalArgumentException("user : null value not allowed");
        }
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setUserDomain(String userDomain) {
        if (userDomain == null) {
            throw new IllegalArgumentException("userDomain : null value not allowed");
        }
        this.userDomain = userDomain;
    }

    public void setPassword(String password) throws MissingJceException {
        this.setLmPassword(password);
        this.setNtPassword(password);
    }

    public String getUserDomain() {
        return this.userDomain;
    }

    public String getDomain() {
        return this.userDomain;
    }

    public void setDomain(String domain) {
        this.setUserDomain(domain);
        this.setHostDomain(domain);
    }

    public void setLmPassword(String password) throws MissingJceException {
        this.addStandardSecurityProvider();
        if (password == null) {
            throw new IllegalArgumentException("lmPassword : null value not allowed");
        }
        try {
            this.lmPassword = NTLM.computeLMPassword(password);
        }
        catch (Exception e) {
            throw new MissingJceException(e.getMessage());
        }
    }

    public String getLmPassword() {
        return this.lmPassword.toString();
    }

    public String getNtPassword() {
        return this.ntPassword.toString();
    }

    public String getPassword() {
        return this.ntPassword.toString();
    }

    public byte[] getLmPasswordHash() {
        return this.lmPassword;
    }

    public byte[] getNtPasswordHash() {
        return this.ntPassword;
    }

    public void setLmPasswordHash(byte[] password) {
        if (password == null) {
            throw new IllegalArgumentException("lmPassword : null value not allowed");
        }
        if (password.length != 16) {
            throw new IllegalArgumentException("lmPassword : illegal size");
        }
        this.lmPassword = password;
    }

    public void setNtPassword(String password) throws MissingJceException {
        this.addStandardSecurityProvider();
        if (password == null) {
            throw new IllegalArgumentException("ntPassword : null value not allowed");
        }
        try {
            this.ntPassword = NTLM.computeNTPassword(password);
        }
        catch (Exception e) {
            throw new MissingJceException(e.getMessage());
        }
    }

    public void setNtPasswordHash(byte[] password) {
        if (password == null) {
            throw new IllegalArgumentException("ntPassword : null value not allowed");
        }
        if (password.length != 16) {
            throw new IllegalArgumentException("ntPassword : illegal size");
        }
        this.ntPassword = password;
    }

    public String toString() {
        return "Host=" + this.host + ", HostDomain=" + this.hostDomain + ", User=" + this.user + ", UserDomain=" + this.userDomain + ", lmPwd=" + this.lmPassword + ", ntPwd=" + this.ntPassword + ", Nonce=" + this.nonce;
    }

    public final void addStandardSecurityProvider() {
        if (!securityProviderAdded) {
            try {
                this.setSecurityProvider("cryptix.jce.provider.CryptixCrypto");
            }
            catch (Exception exception) {
                // empty catch block
            }
            securityProviderAdded = true;
        }
    }

    public void setSecurityProvider(String securityProviderClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.securityProvider = securityProviderClassName;
        if (securityProviderClassName != null) {
            Class<?> securityProvider = Class.forName(securityProviderClassName);
            Security.addProvider((Provider)securityProvider.newInstance());
            securityProviderAdded = true;
        }
    }

    public String getSecurityProvider() {
        return this.securityProvider;
    }

    public boolean isComplete() {
        return this.lmPassword != null && this.ntPassword != null && this.hostDomain != null && this.userDomain != null && this.user != null;
    }

    public void writeToFile(String filename) throws FileNotFoundException, IOException {
        ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(filename));
        os.writeObject(this);
        os.close();
    }

    public static NTLMAuthorization readFromFile(String filename) throws OptionalDataException, ClassNotFoundException, IOException {
        ObjectInputStream is = new ObjectInputStream(new FileInputStream(filename));
        NTLMAuthorization auth = (NTLMAuthorization)is.readObject();
        return auth;
    }

    public void setFilename(String filename) throws OptionalDataException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        NTLMAuthorization auth = NTLMAuthorization.readFromFile(filename);
        this.host = auth.host;
        this.hostDomain = auth.hostDomain;
        this.lmPassword = auth.lmPassword;
        this.ntPassword = auth.ntPassword;
        this.setSecurityProvider(auth.securityProvider);
        this.user = auth.user;
        this.userDomain = auth.userDomain;
    }

    public String getFilename() {
        return null;
    }

    public static void main(String[] args) {
        NTLMAuthorization auth = new NTLMAuthorization();
        try {
            String filename = "";
            for (int i = 0; i < args.length; ++i) {
                String right;
                String s = args[i];
                int sep = s.indexOf("=");
                String left = sep >= 0 ? s.substring(0, sep).toLowerCase() : null;
                String string = right = sep >= 0 ? s.substring(sep + 1) : s;
                if (left == null) {
                    filename = s;
                    continue;
                }
                if (left.equals("-domain")) {
                    auth.setDomain(right);
                    continue;
                }
                if (left.equals("-host")) {
                    auth.setHost(right);
                    continue;
                }
                if (left.equals("-hostdomain")) {
                    auth.setHostDomain(right);
                    continue;
                }
                if (left.equals("-lmpassword")) {
                    auth.setLmPassword(right);
                    continue;
                }
                if (left.equals("-ntpassword")) {
                    auth.setNtPassword(right);
                    continue;
                }
                if (left.equals("-password")) {
                    auth.setPassword(right);
                    continue;
                }
                if (left.equals("-securityprovider")) {
                    auth.setSecurityProvider(right);
                    continue;
                }
                if (left.equals("-user")) {
                    auth.setUser(right);
                    continue;
                }
                if (left.equals("-userDomain")) {
                    auth.setUserDomain(right);
                    continue;
                }
                System.err.println("Unrecognized parameter: " + left);
            }
            if (!auth.isComplete() || filename == null) {
                System.err.println("Syntax: <filename> <-parameter=value>*");
                System.err.println("Required parameters: domain | (hostDomain, userDomain),");
                System.err.println("                     user,");
                System.err.println("                     password | (lmPassword, ntPassword)");
                System.err.println("Optional parameters: securityprovider\n");
                System.err.println("Example            : ntAuth.dat -user=NTLM -domain=TEAMSPORT -password=NTLMNTLM");
                System.exit(0);
            }
            auth.writeToFile(filename);
            System.out.println(filename + " successfully written.");
            auth = NTLMAuthorization.readFromFile(filename);
            System.out.println(filename + " successfully read:");
            System.out.println(auth);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public class MissingJceException
    extends Exception {
        private static final long serialVersionUID = -6580761514651447918L;

        MissingJceException(String msg) {
            super(msg);
        }
    }
}

