/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.http.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import net.matuschek.util.TimedSocket;

public class HttpConnection {
    private Socket socket = null;

    public static HttpConnection createConnection(InetAddress address, int port, int timeout) throws IOException {
        HttpConnection connection = new HttpConnection();
        try {
            connection.socket = TimedSocket.getSocket(address, port, timeout);
            connection.socket.setSoTimeout(timeout);
        }
        catch (InterruptedIOException e) {
            throw new IOException("timeout during connect: " + e.getMessage());
        }
        return connection;
    }

    public InputStream getInputStream() throws IOException {
        if (this.socket == null) {
            throw new IOException("not conected");
        }
        return this.socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.socket == null) {
            throw new IOException("not conected");
        }
        return this.socket.getOutputStream();
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected HttpConnection() {
    }

    public HttpConnection(Socket socket) {
        this.socket = socket;
    }
}

