/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.http.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.matuschek.http.connection.HttpConnection;

public class HttpsHelper {
    boolean useProxy = false;
    InetAddress proxyHost = null;
    int proxyPort = 0;

    public HttpsHelper() {
    }

    public HttpsHelper(InetAddress proxyHost, int proxyPort, boolean useProxy) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.useProxy = useProxy;
    }

    public HttpConnection createHttpsConnection(String host, int port) throws IOException {
        HttpConnection connection = null;
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket socket = null;
        if (!this.useProxy) {
            socket = (SSLSocket)factory.createSocket(host, port);
        } else {
            Socket tunnel = new Socket(this.proxyHost, this.proxyPort);
            this.doTunnelHandshake(tunnel, host, port);
            socket = (SSLSocket)factory.createSocket(tunnel, host, port, true);
            socket.startHandshake();
        }
        connection = new HttpConnection(socket);
        return connection;
    }

    private void doTunnelHandshake(Socket tunnel, String host, int port) throws IOException {
        String replyStr;
        byte[] b;
        OutputStream out = tunnel.getOutputStream();
        String msg = "CONNECT " + host + ":" + port + " HTTP/1.0\n" + "User-Agent: JoBo/1.4beta" + "\r\n\r\n";
        try {
            b = msg.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            b = msg.getBytes();
        }
        out.write(b);
        out.flush();
        byte[] reply = new byte[200];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        InputStream in = tunnel.getInputStream();
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (i == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        try {
            replyStr = new String(reply, 0, replyLen, "ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            replyStr = new String(reply, 0, replyLen);
        }
        if (!replyStr.startsWith("HTTP/1.0 200")) {
            throw new IOException("Unable to tunnel through proxy.  Proxy returns \"" + replyStr + "\"");
        }
    }
}

