/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.http.cookie;

import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import net.matuschek.http.cookie.CookieException;

public class Cookie {
    static final String HEADER_SETCOOKIE = "Set-Cookie:";
    static final String HEADER_COOKIE = "Cookie:";
    private String name;
    private String value = null;
    private long maxAge = -1L;
    private String comment = "";
    private String domain = null;
    private String path = "/";
    private boolean secure = false;
    private Date expireDate = new Date(Long.MAX_VALUE);
    private int version = 0;

    public Cookie() {
    }

    public Cookie(String setCookie, URL u) throws CookieException {
        this();
        String cookieHeader = null;
        String host = "";
        StringTokenizer tokens = null;
        if (!setCookie.substring(0, HEADER_SETCOOKIE.length()).equalsIgnoreCase(HEADER_SETCOOKIE)) {
            throw new CookieException("Not a Set-Cookie header");
        }
        cookieHeader = setCookie.substring(HEADER_SETCOOKIE.length());
        if (u != null) {
            host = this.domain = u.getHost().toLowerCase();
        } else {
            this.domain = "";
        }
        tokens = new StringTokenizer(cookieHeader, ";");
        if (tokens.countTokens() < 1) {
            throw new CookieException("Cookie contains no data");
        }
        String field = tokens.nextToken();
        int pos = field.indexOf(61);
        if (pos <= 0) {
            throw new CookieException("First field not in the format NAME=VALUE but got " + field);
        }
        this.name = field.substring(0, pos).trim();
        this.value = field.substring(pos + 1);
        while (tokens.hasMoreTokens()) {
            String domainvalue;
            field = tokens.nextToken();
            String fieldname = "";
            String fieldvalue = "";
            int pos2 = field.indexOf(61);
            if (pos2 <= 0) {
                fieldname = field.trim();
                fieldvalue = "";
            } else {
                fieldname = field.substring(0, pos2).trim();
                fieldvalue = field.substring(pos2 + 1).trim();
            }
            if (fieldname.equalsIgnoreCase("comment")) {
                this.comment = fieldvalue;
                continue;
            }
            if (fieldname.equalsIgnoreCase("domain")) {
                domainvalue = fieldvalue.toLowerCase();
                if (host.equals("") || host.endsWith(this.domain)) {
                    this.domain = domainvalue;
                    continue;
                }
                throw new CookieException("Not allowed to set a cookie for domain " + domainvalue + " from host " + host);
            }
            if (fieldname.equalsIgnoreCase("jmfdomain")) {
                domainvalue = fieldvalue.toLowerCase();
                if (host.equals("") || host.endsWith(this.domain)) {
                    this.domain = domainvalue;
                    continue;
                }
                throw new CookieException("Not allowed to set a cookie for domain " + domainvalue + " from host " + host);
            }
            if (fieldname.equalsIgnoreCase("path")) {
                this.path = fieldvalue;
                continue;
            }
            if (fieldname.equalsIgnoreCase("secure")) {
                this.secure = true;
                continue;
            }
            if (fieldname.equalsIgnoreCase("max-age")) {
                try {
                    this.maxAge = Integer.parseInt(fieldvalue);
                }
                catch (NumberFormatException e) {
                    throw new CookieException("max-age must be integer, but is " + fieldvalue);
                }
                if (this.maxAge >= 0L) {
                    this.expireDate = new Date(System.currentTimeMillis() + this.maxAge * 1000L);
                    continue;
                }
                this.expireDate = new Date(Long.MAX_VALUE);
                continue;
            }
            if (fieldname.equalsIgnoreCase("expires")) {
                String dateStr = null;
                SimpleDateFormat[] df = new SimpleDateFormat[]{new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("dd MMM yyyy HH:mm:ss z", Locale.US)};
                int commapos = fieldvalue.indexOf(",");
                if (commapos < 0) {
                    throw new CookieException("Expires field does not contain a comma, value is " + fieldvalue);
                }
                dateStr = fieldvalue.substring(commapos + 1).trim();
                boolean foundDate = false;
                for (int i = 0; i < df.length; ++i) {
                    try {
                        this.expireDate = df[i].parse(dateStr);
                        foundDate = true;
                        continue;
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                }
                if (foundDate) continue;
                throw new CookieException("Can't parse expires field as date, value is " + dateStr);
            }
            if (!fieldname.equalsIgnoreCase("version")) continue;
            try {
                this.version = Integer.parseInt(fieldvalue);
            }
            catch (NumberFormatException e) {
                throw new CookieException("Version must be integer, but is " + fieldvalue);
            }
            if (this.version <= 1) continue;
            throw new CookieException("Only version 0 and 1 supported yet, but cookie used version " + this.version);
        }
    }

    public Cookie(String name, String value, String domain, String path) {
        this.name = name;
        this.value = value;
        this.domain = domain;
        this.path = path;
    }

    public boolean isValid() {
        Date current = new Date();
        return current.before(this.expireDate);
    }

    public boolean isValid(URL u) {
        String urlhost = u.getHost().toLowerCase();
        String urlpath = u.getPath();
        return this.isValid() && urlhost.endsWith(this.domain) && urlpath.startsWith(this.path);
    }

    public boolean overwrites(Cookie c) {
        return this.domain.equals(c.domain) && this.path.equals(c.path) && this.name.equals(c.name);
    }

    public String getNameValuePair() {
        return this.name + "=" + this.value;
    }

    public String toString() {
        return this.name + "=" + this.value + " (Comment=" + this.comment + ", Version=" + this.version + ", domain=" + this.domain + ", path=" + this.path + ", expires " + DateFormat.getDateTimeInstance().format(this.expireDate) + ")";
    }

    public static Cookie[] cookieStringToCookies(String cookieStr, String domain) throws CookieException {
        if (!cookieStr.substring(0, HEADER_COOKIE.length()).equalsIgnoreCase(HEADER_COOKIE)) {
            throw new CookieException("Not a Cookie header");
        }
        String cookieHeader = cookieStr.substring(HEADER_COOKIE.length());
        StringTokenizer tokens = new StringTokenizer(cookieHeader, ";");
        Cookie[] cookies = new Cookie[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            cookies[i] = null;
            String field = tokens.nextToken();
            int pos = field.indexOf(61);
            if (pos <= 0) {
                throw new CookieException("Cookie field not in the format NAME=VALUE but got " + field);
            }
            cookies[i] = new Cookie();
            cookies[i].name = field.substring(0, pos).trim();
            cookies[i].value = field.substring(pos + 1);
            cookies[i].domain = "." + domain;
            ++i;
        }
        return cookies;
    }

    public boolean isSecure() {
        return this.secure;
    }
}

