/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.http.cookie;

import java.net.URL;
import java.util.Vector;
import net.matuschek.http.cookie.Cookie;
import net.matuschek.http.cookie.CookieManager;

public class MemoryCookieManager
implements CookieManager {
    private Vector<Cookie> cookies = new Vector();
    private CleanupThread ct = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Cookie cookie) {
        if (this.ct == null) {
            MemoryCookieManager memoryCookieManager = this;
            synchronized (memoryCookieManager) {
                if (this.ct == null) {
                    this.ct = new CleanupThread(this);
                    this.ct.start();
                }
            }
        }
        for (int i = 0; i < this.cookies.size(); ++i) {
            Cookie oldcookie = this.cookies.elementAt(i);
            if (!cookie.overwrites(oldcookie)) continue;
            this.cookies.removeElementAt(i);
            --i;
        }
        this.cookies.add(cookie);
    }

    public int countCookies() {
        return this.cookies.size();
    }

    public String cookiesForURL(URL u) {
        String SEP = "; ";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.cookies.size(); ++i) {
            Cookie c = this.cookies.elementAt(i);
            if (!c.isValid(u)) continue;
            sb.append(c.getNameValuePair());
            sb.append("; ");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - "; ".length());
        }
        return null;
    }

    public void clear() {
        this.cookies.clear();
    }

    protected void cleanUpExpired() {
        for (int i = 0; i < this.cookies.size(); ++i) {
            Cookie c = this.cookies.elementAt(i);
            if (c.isValid()) continue;
            this.cookies.removeElementAt(i);
            --i;
        }
    }

    public void finish() {
        if (this.ct != null) {
            this.ct.finished = true;
            this.ct.interrupt();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.cookies.size(); ++i) {
            sb.append(i + ": ");
            sb.append(this.cookies.elementAt(i).toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    class CleanupThread
    extends Thread {
        MemoryCookieManager cm = null;
        boolean finished = false;

        public CleanupThread(MemoryCookieManager cm) {
            this.cm = cm;
            this.setDaemon(true);
        }

        public void finish() {
            this.finished = true;
        }

        public void run() {
            while (!this.finished) {
                try {
                    CleanupThread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    this.finished = true;
                }
                this.cm.cleanUpExpired();
            }
        }
    }
}

