/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.jobo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.matuschek.swing.JHideFrame;
import net.matuschek.swing.VerticalAlignPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllowedListFrame
extends JHideFrame {
    private static final long serialVersionUID = -5113419291037861467L;
    private Vector<String> urls = null;
    private JList urlList = null;

    public AllowedListFrame(Vector<String> urls) {
        this.urls = urls;
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        this.setTitle("Allowed URLs");
        JPanel completePanel = new JPanel();
        completePanel.setLayout(new GridBagLayout());
        JPanel leftPanel = new JPanel();
        GridBagConstraints consLeft = new GridBagConstraints();
        consLeft.gridx = 0;
        consLeft.gridy = 0;
        completePanel.add((Component)leftPanel, consLeft);
        VerticalAlignPanel rightPanel = new VerticalAlignPanel();
        GridBagConstraints consRight = new GridBagConstraints();
        consRight.gridx = 1;
        consRight.gridy = 0;
        completePanel.add((Component)rightPanel, consRight);
        JButton buttAdd = new JButton();
        buttAdd.setText("Add");
        buttAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AllowedListFrame.this.addURL();
            }
        });
        rightPanel.add(buttAdd, 1);
        JButton buttDelete = new JButton();
        buttDelete.setText("Delete");
        buttDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AllowedListFrame.this.deleteURL();
            }
        });
        rightPanel.add(buttDelete, 1);
        JButton buttClose = new JButton();
        buttClose.setText("Close");
        buttClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AllowedListFrame.this.exitForm();
            }
        });
        rightPanel.add(buttClose, 1);
        this.urlList = new JList();
        this.urlList.setVisibleRowCount(6);
        this.urlList.setMinimumSize(new Dimension(40, 4));
        this.urlList.setListData(this.urls);
        JScrollPane urlScroll = new JScrollPane();
        urlScroll.setViewportView(this.urlList);
        leftPanel.add(urlScroll);
        this.getContentPane().add(completePanel);
    }

    protected void deleteURL() {
        int selected = this.urlList.getMinSelectionIndex();
        if (selected < 0) {
            JOptionPane.showMessageDialog(this, "Please select an URL");
        } else {
            String deleteURL = this.urls.elementAt(selected);
            int yes = JOptionPane.showConfirmDialog(this, "Do you really want to delete " + deleteURL + " ?", "Confirm delete", 0);
            if (yes == 0) {
                this.urls.removeElementAt(selected);
                this.urlList.clearSelection();
            }
        }
    }

    protected void addURL() {
        String newURL = JOptionPane.showInputDialog("Add URL:");
        this.urls.add(newURL);
        this.urlList.setListData(this.urls);
    }
}

