/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.jobo;

import java.io.File;
import java.net.URL;
import net.matuschek.getopt.GetOpt;
import net.matuschek.http.HttpDocToFile;
import net.matuschek.http.SystemOutHttpToolCallback;
import net.matuschek.jobo.JoBoBase;
import net.matuschek.spider.WebRobot;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.PropertyConfigurator;

public class JoBo {
    protected static Category log = Category.getInstance((String)"");

    public static void printUsage() {
        String usageInfo = "command line options: \n [-r http://...]   set start referer (default \"-\")\n [-d maxdepth]     set maximal search depth (default 0)\n [-o]              allow walk to other hosts (default no)\n [-s directory]    directory to store retrieved documents\n                   (default \".\")\n [-m minsize]      store only files larger then this size in bytes\n                   (default 0)\n [-a agentName]    set user agent name\n                   (default \"JoBo\")\n [-i]              ignore robots.txt\n [-w seconds]      wait n seconds after retrieving a file to limit\n                   load on the remote server (default 60)\n [-v]              verbose mode, useful, if something is wrong\n                   with the XML configuration\n url               start URL";
        System.out.println("command line options: \n [-r http://...]   set start referer (default \"-\")\n [-d maxdepth]     set maximal search depth (default 0)\n [-o]              allow walk to other hosts (default no)\n [-s directory]    directory to store retrieved documents\n                   (default \".\")\n [-m minsize]      store only files larger then this size in bytes\n                   (default 0)\n [-a agentName]    set user agent name\n                   (default \"JoBo\")\n [-i]              ignore robots.txt\n [-w seconds]      wait n seconds after retrieving a file to limit\n                   load on the remote server (default 60)\n [-v]              verbose mode, useful, if something is wrong\n                   with the XML configuration\n url               start URL\n\n");
    }

    public static void initializeLogging() {
        String configfile = "logging.conf";
        File f = new File("logging.conf");
        if (f.exists()) {
            PropertyConfigurator.configure((String)"logging.conf");
        } else {
            BasicConfigurator.configure();
        }
    }

    public static void main(String[] argv) throws Exception {
        String basedir = ".";
        int minSize = 0;
        JoBo.initializeLogging();
        if (argv.length < 1) {
            JoBo.printUsage();
            return;
        }
        GetOpt opt = new GetOpt(argv);
        String option = null;
        JoBoBase jobobase = JoBoBase.createFromXML();
        WebRobot robby = jobobase.getRobot();
        option = opt.getOptionString("r");
        if (option != null) {
            robby.setStartReferer(option);
        }
        if ((option = opt.getOptionString("d")) != null) {
            try {
                int maxDepth = Integer.parseInt(option);
                robby.setMaxDepth(maxDepth);
            }
            catch (NumberFormatException e) {
                System.out.println("Wrong number for maxDepth: " + option);
            }
        }
        if (opt.getOptionBoolean("o")) {
            robby.setWalkToOtherHosts(true);
        }
        if ((option = opt.getOptionString("s")) != null) {
            basedir = option;
        }
        if ((option = opt.getOptionString("m")) != null) {
            try {
                minSize = Integer.parseInt(option);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((option = opt.getOptionString("a")) != null) {
            robby.setAgentName(option);
        }
        if (opt.getOptionBoolean("i")) {
            robby.setIgnoreRobotsTxt(true);
        }
        if ((option = opt.getOptionString("w")) != null) {
            try {
                int waitTime = Integer.parseInt(option);
                robby.setSleepTime(waitTime * 1000);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (opt.getOptionBoolean("?")) {
            JoBo.printUsage();
            return;
        }
        URL u = new URL(argv[argv.length - 1]);
        HttpDocToFile docStore = new HttpDocToFile(basedir);
        docStore.setMinFileSize(minSize);
        SystemOutHttpToolCallback statusInfo = new SystemOutHttpToolCallback();
        robby.setStartURL(u);
        robby.setDocManager(docStore);
        robby.setHttpToolCallback(statusInfo);
        robby.run();
    }
}

