/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.jobo;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import net.matuschek.http.DownloadRuleSet;
import net.matuschek.http.HttpDocToFile;
import net.matuschek.http.HttpToolCallback;
import net.matuschek.spider.RegExpURLCheck;
import net.matuschek.spider.WebRobot;
import net.matuschek.spider.WebRobotCallback;
import net.matuschek.spider.docfilter.FilterChain;
import net.matuschek.spider.docfilter.LinkLocalizer;
import org.apache.log4j.Category;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.InputSource;

public class JoBoBase {
    private static Category log = Category.getInstance((String)"");
    private static String mappingfile = "mapping.xml";
    private static String xmlconfig = "jobo.xml";
    private String storageDirectory = "/tmp";
    private WebRobot robot = null;
    private RegExpURLCheck urlcheck = null;
    private DownloadRuleSet downloadrules = null;
    private HttpDocToFile docstore = null;
    private LinkLocalizer linkLocalizer = null;
    private FilterChain filters = null;

    public JoBoBase() throws ClassNotFoundException {
        log = Category.getInstance(this.getClass());
        this.docstore = new HttpDocToFile(this.storageDirectory);
        this.initializeFilters();
        this.robot = new WebRobot();
        this.robot.setFilters(this.filters);
    }

    public void initializeFilters() {
        this.filters = new FilterChain();
        this.linkLocalizer = new LinkLocalizer();
        this.filters.add(this.linkLocalizer);
    }

    public void saveConfig(String filename) {
        File f1 = new File(mappingfile);
        if (f1.exists()) {
            Mapping mapping = new Mapping();
            try {
                mapping.loadMapping(mappingfile);
                FileWriter writer = new FileWriter(filename);
                Marshaller marshaller = new Marshaller((Writer)writer);
                marshaller.setMapping(mapping);
                marshaller.marshal((Object)this);
                ((Writer)writer).close();
                log.info((Object)"written to XML");
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            log.error((Object)"mapping and/or configfile not found");
        }
    }

    public void registerHttpToolCallback(HttpToolCallback cb) {
        this.robot.setHttpToolCallback(cb);
    }

    public void registerWebRobotCallback(WebRobotCallback cb) {
        this.robot.setWebRobotCallback(cb);
    }

    public void configureRobot() {
        this.robot.setURLCheck(this.urlcheck);
        this.robot.setDownloadRuleSet(this.downloadrules);
        this.robot.setDocManager(this.docstore);
        this.robot.setFilters(this.filters);
    }

    public RegExpURLCheck getURLCheck() {
        return this.urlcheck;
    }

    public void setURLCheck(RegExpURLCheck urlcheck) {
        this.urlcheck = urlcheck;
    }

    public WebRobot getRobot() {
        return this.robot;
    }

    public void setRobot(WebRobot robot) {
        this.robot = robot;
        robot.setFilters(this.filters);
    }

    public void setLocalizeLinks(boolean localize) {
        if (localize) {
            this.linkLocalizer.enable();
        } else {
            this.linkLocalizer.disable();
        }
    }

    public boolean getLocalizeLinks() {
        return this.linkLocalizer.isEnabled();
    }

    public DownloadRuleSet getDownloadRuleSet() {
        return this.downloadrules;
    }

    public void setDownloadRuleSet(DownloadRuleSet downloadRuleSet) {
        this.downloadrules = downloadRuleSet;
    }

    public String getStorageDirectory() {
        return this.storageDirectory;
    }

    public void setStorageDirectory(String storageDirectory) {
        this.storageDirectory = storageDirectory;
        this.docstore.setBaseDir(storageDirectory);
    }

    public void setStoreCGI(boolean storeCGI) {
        this.docstore.setStoreCGI(storeCGI);
    }

    public boolean getStoreCGI() {
        return this.docstore.getStoreCGI();
    }

    public static JoBoBase createFromXML() throws ClassNotFoundException {
        return JoBoBase.createFromXML(".");
    }

    public static JoBoBase createFromXML(String configDirectory) throws ClassNotFoundException {
        JoBoBase baseobj = null;
        xmlconfig = "jobo.xml";
        File f1 = new File(configDirectory + File.separatorChar + mappingfile);
        File f2 = new File(configDirectory + File.separatorChar + xmlconfig);
        if (f1.exists() && f2.exists()) {
            Mapping mapping = new Mapping();
            try {
                mapping.loadMapping(f1.getPath());
                Unmarshaller unmar = new Unmarshaller(mapping);
                unmar.setDebug(true);
                baseobj = (JoBoBase)unmar.unmarshal(new InputSource(f2.getPath()));
                log.info((Object)"configured from XML");
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
                e.printStackTrace();
            }
        } else {
            log.error((Object)"mapping and/or configfile not found");
        }
        if (baseobj == null) {
            baseobj = new JoBoBase();
        }
        baseobj.configureRobot();
        return baseobj;
    }
}

