/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.jobo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import net.matuschek.http.HttpToolCallback;
import net.matuschek.http.cookie.Cookie;
import net.matuschek.http.cookie.CookieException;
import net.matuschek.jobo.AllowedListFrame;
import net.matuschek.jobo.FilterConfigFrame;
import net.matuschek.jobo.JoBoBase;
import net.matuschek.jobo.LogFrame;
import net.matuschek.jobo.LogFrameAppender;
import net.matuschek.jobo.RobotConfigFrame;
import net.matuschek.jobo.URLCheckConfigFrame;
import net.matuschek.spider.WebRobotCallback;
import net.matuschek.swing.OptionPanel;
import net.matuschek.swing.VerticalAlignPanel;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;

public class JoBoSwing
extends JFrame
implements HttpToolCallback,
WebRobotCallback {
    static final String VERSION = "1.4";
    private static LogFrame logFrame;
    private static LogFrameAppender lfAppend;
    private JoBoBase jobobase = null;
    private Thread robotThread = null;
    private Date docDownloadStarted = new Date();
    private long httpToolDocSize = 0L;
    private int robotCount = 0;
    private long robotSize = 0L;
    private int robotQueueSize = 0;
    private JTextField urlField;
    private JTextField directoryField;
    private JProgressBar progressBar;
    private JTextField currentUrlField;
    private JTextField queuedField;
    private JTextField retrievedField;
    private JButton runStopButton;
    private JButton sleepButton;
    private RobotConfigFrame robotConfigFrame = null;
    private URLCheckConfigFrame urlCheckConfigFrame = null;
    private FilterConfigFrame filterConfigFrame = null;
    private AllowedListFrame allowedURLsFrame = null;

    public JoBoSwing() {
        try {
            this.jobobase = JoBoBase.createFromXML();
        }
        catch (ClassNotFoundException e) {
            System.out.println("Could not initialize WebRobot: " + e);
            System.exit(1);
        }
        this.jobobase.registerHttpToolCallback(this);
        this.jobobase.registerWebRobotCallback(this);
        this.initComponents();
        this.pack();
        this.updateDialogFromRobot();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle("JoBo/Swing: http://www.matuschek.net/jobo/");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JoBoSwing.this.exitApp();
            }
        });
        VerticalAlignPanel headPanel = new VerticalAlignPanel();
        JLabel heading1 = new JLabel();
        heading1.setText("JoBo 1.4");
        heading1.setHorizontalAlignment(0);
        heading1.setFont(new Font("Dialog", 0, 24));
        JLabel heading2 = new JLabel();
        heading2.setText("look at http://www.matuschek.net/jobo/");
        heading2.setHorizontalAlignment(0);
        heading2.setFont(new Font("Dialog", 0, 12));
        JLabel heading3 = new JLabel();
        heading3.setText("for more details");
        heading3.setHorizontalAlignment(0);
        heading3.setFont(new Font("Dialog", 0, 12));
        headPanel.add(heading1);
        headPanel.add(heading2);
        headPanel.add(heading3);
        this.getContentPane().add((Component)headPanel, "North");
        OptionPanel optPanel = new OptionPanel(2);
        this.urlField = new JTextField();
        this.urlField.setColumns(40);
        this.urlField.setText("http://");
        optPanel.add("URL:", this.urlField);
        this.directoryField = new JTextField();
        this.directoryField.setText(this.jobobase.getStorageDirectory());
        this.directoryField.setColumns(40);
        optPanel.add("Storage directory:", this.directoryField);
        this.currentUrlField = new JTextField();
        this.currentUrlField.setEditable(false);
        this.currentUrlField.setColumns(40);
        this.currentUrlField.setText("-");
        optPanel.add("Current URL:", this.currentUrlField);
        this.retrievedField = new JTextField();
        this.retrievedField.setEditable(false);
        this.retrievedField.setColumns(40);
        optPanel.add("Retrieved:", this.retrievedField);
        this.queuedField = new JTextField();
        this.queuedField.setEditable(false);
        this.queuedField.setColumns(40);
        optPanel.add("Queued:", this.queuedField);
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        optPanel.add("Progress:", this.progressBar, 2);
        this.getContentPane().add(optPanel);
        JPanel buttonPanel = new JPanel();
        JButton butt = null;
        this.runStopButton = new JButton();
        this.runStopButton.setText("Run");
        this.runStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JoBoSwing.this.runStopButtonActionPerformed();
            }
        });
        buttonPanel.add(this.runStopButton);
        this.sleepButton = new JButton();
        this.sleepButton.setText("Sleep");
        this.sleepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JoBoSwing.this.sleepButtonActionPerformed();
            }
        });
        buttonPanel.add(this.sleepButton);
        butt = new JButton();
        butt.setText("Robot settings");
        butt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JoBoSwing.this.doRobotSettingsDialog();
            }
        });
        buttonPanel.add(butt);
        butt = new JButton();
        butt.setText("Save");
        butt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JoBoSwing.this.saveSettings();
            }
        });
        butt = new JButton();
        butt.setText("URLCheck");
        butt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JoBoSwing.this.configureURLCheck();
            }
        });
        butt = new JButton();
        butt.setText("Filter configuration");
        butt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JoBoSwing.this.configureFilters();
            }
        });
        butt = new JButton();
        butt.setText("Allowed URLs");
        butt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JoBoSwing.this.configureAllowedURLs();
            }
        });
        buttonPanel.add(butt);
        butt = new JButton();
        butt.setText("Add cookie");
        butt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JoBoSwing.this.addCookie();
            }
        });
        buttonPanel.add(butt);
        butt = new JButton();
        butt.setText("Log");
        butt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JoBoSwing.this.logButtonActionPerformed();
            }
        });
        buttonPanel.add(butt);
        butt = new JButton();
        butt.setText("Exit");
        butt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JoBoSwing.this.exitApp();
            }
        });
        buttonPanel.add(butt);
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    private void sleepButtonActionPerformed() {
        if (this.robotThread != null && this.robotThread.isAlive()) {
            if (this.jobobase.getRobot().isSleeping()) {
                this.jobobase.getRobot().setSleep(false);
                this.sleepButton.setText("Sleep");
            } else {
                this.jobobase.getRobot().setSleep(true);
                this.sleepButton.setText("Wake up");
            }
        }
    }

    private void logButtonActionPerformed() {
        logFrame.setVisible(true);
    }

    private void runStopButtonActionPerformed() {
        if (this.robotThread != null && this.robotThread.isAlive()) {
            this.jobobase.getRobot().stopRobot();
        } else if (this.updateRobotFromDialog()) {
            this.runStopButton.setText("Stop");
            this.robotThread = new Thread(this.jobobase.getRobot());
            this.robotThread.start();
        }
    }

    private void doRobotSettingsDialog() {
        if (this.robotConfigFrame == null) {
            this.robotConfigFrame = new RobotConfigFrame(this.jobobase);
        }
        this.robotConfigFrame.setVisible(true);
    }

    private void configureURLCheck() {
        if (this.urlCheckConfigFrame == null) {
            this.urlCheckConfigFrame = new URLCheckConfigFrame(this.jobobase.getURLCheck());
        }
        this.urlCheckConfigFrame.setVisible(true);
    }

    private void addCookie() {
        URL url;
        String cookieStr = JOptionPane.showInputDialog(this, (Object)"Cookie string:");
        String domain = JOptionPane.showInputDialog(this, (Object)"Domain:");
        try {
            url = new URL("http://" + domain);
        }
        catch (MalformedURLException e1) {
            JOptionPane.showMessageDialog(this, "Domain invalid: " + e1.getMessage());
            return;
        }
        try {
            if (cookieStr.startsWith("Set-Cookie")) {
                Cookie cookie = new Cookie(cookieStr, url);
                this.jobobase.getRobot().getCookieManager().add(cookie);
                JOptionPane.showMessageDialog(this, "Cookie added");
            } else {
                Cookie[] cookies = Cookie.cookieStringToCookies(cookieStr, domain);
                for (int i = 0; i < cookies.length; ++i) {
                    System.out.println(cookies[i]);
                    this.jobobase.getRobot().getCookieManager().add(cookies[i]);
                }
                JOptionPane.showMessageDialog(this, cookies.length + " cookies added");
            }
        }
        catch (CookieException e) {
            JOptionPane.showMessageDialog(this, "Cookie string invalid: " + e.getMessage());
        }
    }

    private void configureFilters() {
        if (this.filterConfigFrame == null) {
            this.filterConfigFrame = new FilterConfigFrame();
        }
        this.filterConfigFrame.setVisible(true);
    }

    private void configureAllowedURLs() {
        if (this.allowedURLsFrame == null) {
            this.allowedURLsFrame = new AllowedListFrame(this.jobobase.getRobot().getAllowedURLs());
        }
        this.allowedURLsFrame.setVisible(true);
    }

    private void saveSettings() {
        this.jobobase.saveConfig("test.xml");
    }

    private void exitApp() {
        System.exit(0);
    }

    public static void main(String[] args) {
        logFrame = new LogFrame();
        logFrame.addMsg("Starting ...");
        lfAppend = new LogFrameAppender(logFrame);
        BasicConfigurator.configure((Appender)lfAppend);
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-debug")) continue;
            BasicConfigurator.configure();
        }
        new JoBoSwing().setVisible(true);
    }

    private boolean updateRobotFromDialog() {
        String startUrl = this.urlField.getText();
        try {
            URL u = new URL(startUrl);
            this.jobobase.getRobot().setStartURL(u);
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(this, "URL " + startUrl + " is invalid");
            return false;
        }
        String storageDir = this.directoryField.getText();
        this.jobobase.setStorageDirectory(storageDir);
        return true;
    }

    private void updateDialogFromRobot() {
        URL u = this.jobobase.getRobot().getStartURL();
        if (u != null) {
            this.urlField.setText(u.toString());
        } else {
            this.urlField.setText("");
        }
    }

    public void setHttpToolDocUrl(String url) {
        try {
            this.currentUrlField.setText(this.urlToString(new URL(url)));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setHttpToolDocSize(int size) {
        this.httpToolDocSize = size;
        this.progressBar.setMaximum(size);
    }

    public void setHttpToolDocCurrentSize(int size) {
        StringBuffer progressStr = new StringBuffer();
        this.progressBar.setValue(size);
        int kB = size / 1024;
        long longsize = size;
        Date current = new Date();
        long millisecs = current.getTime() - this.docDownloadStarted.getTime();
        long ratio = 0L;
        ratio = millisecs > 0L ? longsize * 1000L / millisecs : 0L;
        progressStr.append(kB);
        progressStr.append(" kB");
        if (this.httpToolDocSize > 0L) {
            progressStr.append(" of ");
            progressStr.append(this.httpToolDocSize / 1024L);
            progressStr.append(" kB");
        }
        DecimalFormat myFormat = new DecimalFormat("####0.000");
        progressStr.append(", ");
        progressStr.append(myFormat.format((float)ratio / 1000.0f));
        progressStr.append(" kB/s");
        if (this.httpToolDocSize > 0L) {
            long secleft = ratio > 0L ? (this.httpToolDocSize - longsize) / ratio : 100000L;
            long min = secleft / 60L;
            int sec = (int)(secleft % 60L);
            String secStr = Integer.toString(sec);
            if (secStr.length() < 2) {
                secStr = "0" + secStr;
            }
            progressStr.append(", ");
            progressStr.append(min);
            progressStr.append(":");
            progressStr.append(secStr);
            progressStr.append(" min left");
        }
        this.progressBar.setString(progressStr.toString());
    }

    public void setHttpToolStatus(int status) {
        if (status == 0) {
            this.progressBar.setString("Connecting");
            this.setHttpToolDocSize(0);
        } else if (status == 1) {
            this.progressBar.setString("Connected");
            this.docDownloadStarted = new Date();
        } else if (status == 2) {
            this.progressBar.setString("Retrieving");
        } else if (status == 3) {
            this.progressBar.setString("Finished");
        } else if (status == 4) {
            this.progressBar.setString("Denied by rule");
        } else {
            this.progressBar.setString("Unknown status (" + status + ")");
        }
    }

    protected String urlToString(URL u) {
        if (u == null) {
            return null;
        }
        String userInfo = u.getUserInfo();
        userInfo = userInfo != null && !userInfo.equals("") ? "authenticated@" : "";
        return u.getProtocol() + "://" + userInfo + u.getHost() + u.getPath();
    }

    public void webRobotRetrievedDoc(String url, int size) {
        ++this.robotCount;
        this.robotSize += (long)size;
        this.updateControls();
    }

    public void webRobotUpdateQueueStatus(int length) {
        this.robotQueueSize = length;
        this.updateControls();
    }

    public void webRobotDone() {
        this.progressBar.setString("Download completed");
        this.robotCount = 0;
        this.robotSize = 0L;
        this.runStopButton.setText("Run");
    }

    public void webRobotSleeping(boolean sleeping) {
        if (sleeping) {
            this.progressBar.setString("sleeping");
        } else {
            this.progressBar.setString("");
        }
    }

    protected void updateControls() {
        DecimalFormat myFormat = new DecimalFormat("###,###,###.0");
        String retrievedContent = this.robotCount + " files with " + myFormat.format((float)this.robotSize / 1024.0f) + " kB";
        String queuedContent = this.robotQueueSize + "";
        this.retrievedField.setText(retrievedContent);
        this.queuedField.setText(queuedContent);
    }

    static {
        lfAppend = null;
    }
}

