/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.jobo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.matuschek.http.HttpException;
import net.matuschek.jobo.JoBoBase;
import net.matuschek.spider.WebRobot;
import net.matuschek.swing.JHideFrame;
import net.matuschek.swing.OptionPanel;
import net.matuschek.swing.SwingHelper;

public class RobotConfigFrame
extends JHideFrame {
    private static final long serialVersionUID = 8977779246579784214L;
    WebRobot robot = null;
    JoBoBase jobobase = null;
    JTextField agentNameField = null;
    JTextField startRefererField = null;
    JTextField proxyField = null;
    JTextField maxDepthField = null;
    JTextField sleepField = null;
    JTextField bandwidthField = null;
    JTextField maxAgeField = null;
    JCheckBox cookiesEnabled = null;
    JCheckBox allowWholeHost = null;
    JCheckBox allowWholeDomain = null;
    JCheckBox flexibleHostCheck = null;
    JCheckBox ignoreRobotsTxt = null;
    JCheckBox localizeLinks = null;
    JCheckBox storeCGI = null;
    JCheckBox allowCaching = null;

    public RobotConfigFrame(JoBoBase jobobase) {
        super("Robot configuration");
        this.robot = jobobase.getRobot();
        this.jobobase = jobobase;
        this.initComponents();
    }

    protected void initComponents() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.setContentPane(mainPanel);
        OptionPanel dialogPanel = new OptionPanel(2);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        mainPanel.add(dialogPanel);
        mainPanel.add(buttonPanel);
        this.agentNameField = SwingHelper.createInputField(25);
        dialogPanel.add("Agent name:", this.agentNameField);
        this.startRefererField = SwingHelper.createInputField(25);
        dialogPanel.add("Start referer:", this.startRefererField);
        this.proxyField = SwingHelper.createInputField(25);
        dialogPanel.add("Proxy (host:port or empty):", this.proxyField);
        this.maxDepthField = SwingHelper.createInputField(5);
        dialogPanel.add("Maximal search depth:", this.maxDepthField);
        this.sleepField = SwingHelper.createInputField(5);
        dialogPanel.add("Sleep time (in seconds)", this.sleepField);
        this.bandwidthField = SwingHelper.createInputField(5);
        dialogPanel.add("Bandwidth limit in Bytes/s (0 to disable)", this.bandwidthField);
        this.maxAgeField = SwingHelper.createInputField(5);
        dialogPanel.add("Maximum age in days (leave empty to disable)", this.maxAgeField);
        this.cookiesEnabled = new JCheckBox();
        dialogPanel.add("Enable cookies", this.cookiesEnabled);
        this.allowWholeHost = new JCheckBox();
        dialogPanel.add("Allow all URLs on start host", this.allowWholeHost);
        this.allowWholeDomain = new JCheckBox();
        dialogPanel.add("Allow all URLs in the same domain", this.allowWholeDomain);
        this.flexibleHostCheck = new JCheckBox();
        dialogPanel.add("Do flexible host checking", this.flexibleHostCheck);
        this.ignoreRobotsTxt = new JCheckBox();
        dialogPanel.add("Ignore robots.txt", this.ignoreRobotsTxt);
        this.localizeLinks = new JCheckBox();
        dialogPanel.add("Localize links", this.localizeLinks);
        this.storeCGI = new JCheckBox();
        dialogPanel.add("Save dynamic pages", this.storeCGI);
        this.allowCaching = new JCheckBox();
        dialogPanel.add("Don't retrieve pages that are already on disk (resume download)", this.allowCaching);
        JButton okButton = new JButton();
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RobotConfigFrame.this.updateAndHide();
            }
        });
        buttonPanel.add(okButton);
        JButton closeButton = new JButton();
        closeButton.setText("Cancel");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RobotConfigFrame.this.exitForm();
            }
        });
        buttonPanel.add(closeButton);
        this.pack();
        this.updateFormFromRobot();
    }

    protected void updateAndHide() {
        if (this.updateRobotFromForm()) {
            this.setVisible(false);
        }
    }

    protected void updateFormFromRobot() {
        this.agentNameField.setText(this.robot.getAgentName());
        this.startRefererField.setText(this.robot.getStartReferer());
        this.proxyField.setText(this.robot.getProxy());
        this.maxDepthField.setText(String.valueOf(this.robot.getMaxDepth()));
        this.sleepField.setText(String.valueOf(this.robot.getSleepTime()));
        this.bandwidthField.setText(String.valueOf(this.robot.getBandwidth()));
        long maxAge = this.robot.getMaxDocumentAge();
        if (maxAge > 0L) {
            this.maxAgeField.setText(Long.toString(maxAge / 86400L));
        } else {
            this.maxAgeField.setText("");
        }
        this.cookiesEnabled.setSelected(this.robot.getEnableCookies());
        this.allowWholeHost.setSelected(this.robot.getAllowWholeHost());
        this.allowWholeDomain.setSelected(this.robot.getAllowWholeDomain());
        this.flexibleHostCheck.setSelected(this.robot.getFlexibleHostCheck());
        this.ignoreRobotsTxt.setSelected(this.robot.getIgnoreRobotsTxt());
        this.localizeLinks.setSelected(this.jobobase.getLocalizeLinks());
        this.storeCGI.setSelected(this.jobobase.getStoreCGI());
        this.allowCaching.setSelected(this.robot.getAllowCaching());
    }

    protected boolean updateRobotFromForm() {
        this.robot.setAgentName(this.agentNameField.getText());
        this.robot.setStartReferer(this.startRefererField.getText());
        try {
            this.robot.setProxy(this.proxyField.getText());
        }
        catch (HttpException e) {
            // empty catch block
        }
        try {
            this.robot.setMaxDepth(Integer.parseInt(this.maxDepthField.getText()));
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Maximal depth must be a number", "Error", 0);
            return false;
        }
        try {
            this.robot.setSleepTime(Integer.parseInt(this.sleepField.getText()));
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Sleep time must be a number", "Error", 0);
            return false;
        }
        try {
            this.robot.setBandwidth(Integer.parseInt(this.bandwidthField.getText()));
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Bandwidth must be an integer", "Error", 0);
            return false;
        }
        if (!this.maxAgeField.getText().equals("")) {
            try {
                int age = Integer.parseInt(this.maxAgeField.getText());
                this.robot.setMaxDocumentAge(age * 86400);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Age must be an integer", "Error", 0);
                return false;
            }
        } else {
            this.robot.setMaxDocumentAge(-1L);
        }
        this.robot.setEnableCookies(this.cookiesEnabled.isSelected());
        this.robot.setAllowWholeHost(this.allowWholeHost.isSelected());
        this.robot.setAllowWholeDomain(this.allowWholeDomain.isSelected());
        this.robot.setFlexibleHostCheck(this.flexibleHostCheck.isSelected());
        this.robot.setIgnoreRobotsTxt(this.ignoreRobotsTxt.isSelected());
        this.robot.setAllowCaching(this.allowCaching.isSelected());
        this.jobobase.setLocalizeLinks(this.localizeLinks.isSelected());
        this.jobobase.setStoreCGI(this.storeCGI.isSelected());
        return true;
    }
}

