/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.spider;

import java.util.HashSet;
import java.util.LinkedList;
import net.matuschek.spider.RobotTask;
import net.matuschek.spider.TaskList;

public class HashedMemoryTaskList
implements TaskList {
    public static int DEFAULT_CAPACITY = 50000;
    private LinkedList list = new LinkedList();
    private HashSet hashset = null;
    private boolean sequentialAccess;

    public HashedMemoryTaskList() {
        this(true, DEFAULT_CAPACITY);
    }

    public HashedMemoryTaskList(boolean sequentialAccess) {
        this(sequentialAccess, DEFAULT_CAPACITY);
    }

    public HashedMemoryTaskList(boolean sequentialAccess, int initialCapacity) {
        this.sequentialAccess = sequentialAccess;
        this.hashset = new HashSet(initialCapacity);
    }

    public synchronized void add(RobotTask task) {
        if (this.sequentialAccess) {
            this.list.add(task);
        }
        this.hashset.add(task);
    }

    public synchronized void addAtStart(RobotTask task) {
        if (this.sequentialAccess) {
            this.list.add(0, task);
        }
        this.hashset.add(task);
    }

    public synchronized void clear() {
        this.list.clear();
        this.hashset.clear();
    }

    public synchronized boolean contains(RobotTask task) {
        return this.hashset.contains(task);
    }

    public synchronized boolean remove(RobotTask task) {
        this.hashset.remove(task);
        if (this.sequentialAccess) {
            return this.list.remove(task);
        }
        return true;
    }

    public synchronized RobotTask removeFirst() throws ArrayIndexOutOfBoundsException {
        if (!this.sequentialAccess) {
            throw new ArrayIndexOutOfBoundsException("sequential access not allowed");
        }
        RobotTask task = (RobotTask)this.list.removeFirst();
        this.hashset.remove(task);
        return task;
    }

    public synchronized int size() {
        return this.hashset.size();
    }

    public synchronized RobotTask elementAt(int position) throws ArrayIndexOutOfBoundsException {
        if (!this.sequentialAccess) {
            throw new ArrayIndexOutOfBoundsException("sequential access not allowed");
        }
        return (RobotTask)this.list.get(position);
    }
}

