/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.spider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.matuschek.http.HttpDoc;
import net.matuschek.http.HttpException;
import net.matuschek.http.HttpTool;
import net.matuschek.util.LruHashtable;
import org.apache.log4j.Category;

public class NoRobots {
    Category log = Category.getInstance((String)this.getClass().getName());
    private static final String robotFile = "/robots.txt";
    private String robotName;
    private Hashtable servers = new LruHashtable(500);
    private HttpTool httpTool;
    private boolean ignore = false;

    public NoRobots(String robotName, HttpTool inhttpTool) {
        this.robotName = robotName;
        this.httpTool = inhttpTool;
    }

    public boolean ok(URL url) {
        if (this.ignore) {
            return true;
        }
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        if (port == -1) {
            port = 80;
        }
        String file = url.getFile();
        Vector disallows = this.getDisallows(protocol, host, port);
        Enumeration en = disallows.elements();
        while (en.hasMoreElements()) {
            String pattern = (String)en.nextElement();
            if (!file.startsWith(pattern)) continue;
            return false;
        }
        return true;
    }

    private Vector getDisallows(String protocol, String host, int port) {
        String key = protocol + "://" + host + ":" + port;
        Vector<String> disallows = (Vector<String>)this.servers.get(key);
        if (disallows != null) {
            return disallows;
        }
        disallows = new Vector<String>();
        try {
            URL robotUrl = new URL(protocol, host, port, robotFile);
            try {
                String line;
                this.log.debug((Object)("Retrieving robot file '" + robotUrl + "'."));
                this.httpTool.setReferer("-");
                String robotsFile = "";
                try {
                    HttpDoc doc = this.httpTool.retrieveDocument(robotUrl, 1, "");
                    if (doc != null && doc.isOk()) {
                        robotsFile = new String(doc.getContent());
                    }
                }
                catch (HttpException e) {
                    this.log.info((Object)("Cannot read robots.txt: " + e.getMessage()));
                }
                BufferedReader robotReader = new BufferedReader(new StringReader(robotsFile));
                boolean userAgentIsMe = false;
                while ((line = robotReader.readLine()) != null) {
                    String value;
                    if ((line = line.trim()).startsWith("#")) continue;
                    int cmt = line.indexOf(35);
                    if (cmt != -1) {
                        line = line.substring(0, cmt).trim();
                    }
                    if (line.length() == 0) {
                        userAgentIsMe = false;
                        continue;
                    }
                    if (line.toLowerCase().startsWith("user-agent:")) {
                        if (userAgentIsMe || !NoRobots.match(value = line.substring(11).trim(), this.robotName)) continue;
                        userAgentIsMe = true;
                        continue;
                    }
                    if (!line.toLowerCase().startsWith("disallow:") || !userAgentIsMe) continue;
                    value = line.substring(9).trim();
                    disallows.addElement(value);
                }
            }
            catch (IOException ignore) {
            }
        }
        catch (MalformedURLException ignore) {
            // empty catch block
        }
        this.servers.put(key, disallows);
        return disallows;
    }

    protected static boolean match(String pattern, String string) {
        int p = 0;
        while (true) {
            int s = 0;
            while (true) {
                boolean pEnd;
                boolean sEnd = s >= string.length();
                boolean bl = pEnd = p >= pattern.length() || pattern.charAt(p) == '|';
                if (sEnd && pEnd) {
                    return true;
                }
                if (sEnd || pEnd) break;
                if (pattern.charAt(p) != '?') {
                    if (pattern.charAt(p) == '*') {
                        ++p;
                        for (int i = string.length(); i >= s; --i) {
                            if (!NoRobots.match(pattern.substring(p), string.substring(i))) continue;
                            return true;
                        }
                        break;
                    }
                    if (pattern.charAt(p) != string.charAt(s)) break;
                }
                ++p;
                ++s;
            }
            if ((p = pattern.indexOf(124, p)) == -1) {
                return false;
            }
            ++p;
        }
    }

    public boolean getIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public void finish() {
        if (this.httpTool != null) {
            this.httpTool.finish();
        }
    }
}

