/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.spider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import net.matuschek.spider.RegExpRule;
import net.matuschek.spider.URLCheck;
import org.apache.regexp.RESyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegExpURLCheck
implements URLCheck {
    private Vector<RegExpRule> rules = new Vector();
    private boolean defaultResult = true;

    public RegExpURLCheck() {
    }

    public RegExpURLCheck(Reader r) throws IOException, RESyntaxException {
        this();
        BufferedReader reader = new BufferedReader(r);
        String line = "";
        int lineno = 0;
        while (line != null) {
            line = reader.readLine();
            ++lineno;
            if (line == null || line.trim().equals("") || line.startsWith("#")) continue;
            StringTokenizer st = new StringTokenizer(line);
            if (st.countTokens() != 2) {
                throw new IOException("line " + lineno + " don't consists of 2 fields");
            }
            String allowStr = st.nextToken();
            boolean allow = true;
            String expression = st.nextToken();
            if (allowStr.equalsIgnoreCase("allow")) {
                allow = true;
            } else if (allowStr.equalsIgnoreCase("deny")) {
                allow = false;
            } else {
                throw new IOException("first token in line " + lineno + " has to be allow or deny");
            }
            this.addRule(expression, allow);
        }
    }

    public void setDefaultResult(boolean defaultResult) {
        this.defaultResult = defaultResult;
    }

    public boolean getDefaultResult() {
        return this.defaultResult;
    }

    public Vector getRules() {
        return this.rules;
    }

    public void setRules(Vector<RegExpRule> rules) {
        this.rules = rules;
    }

    public void addRule(String regExp, boolean allow) throws RESyntaxException {
        RegExpRule rule = new RegExpRule();
        rule.setPattern(regExp);
        rule.setAllow(allow);
        this.rules.add(rule);
    }

    @Override
    public boolean checkURL(URL u) {
        String urlStr = u.toString();
        for (int i = 0; i < this.rules.size(); ++i) {
            RegExpRule rule = this.rules.elementAt(i);
            if (!rule.match(urlStr)) continue;
            return rule.getAllow();
        }
        return this.defaultResult;
    }

    @Override
    public boolean checkURLForProcessing(URL u) {
        String urlStr = u.toString();
        for (int i = 0; i < this.rules.size(); ++i) {
            RegExpRule rule = this.rules.elementAt(i);
            if (!rule.match(urlStr)) continue;
            return rule.getProcessAllowed();
        }
        return this.defaultResult;
    }
}

