/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.spider.docfilter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import net.matuschek.http.HttpDoc;
import net.matuschek.spider.docfilter.DocumentFilter;
import net.matuschek.spider.docfilter.FilterException;
import net.matuschek.util.NullWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

public class LinkLocalizer
implements DocumentFilter {
    protected boolean enabled = true;

    public HttpDoc process(HttpDoc input) throws FilterException {
        if (input == null) {
            return null;
        }
        if (!input.isHTML()) {
            return input;
        }
        if (!this.enabled) {
            return input;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(input.getContent());
        Tidy tidy = new Tidy();
        tidy.setUpperCaseTags(false);
        tidy.setUpperCaseAttrs(false);
        tidy.setErrout(new PrintWriter(new NullWriter()));
        Document doc = tidy.parseDOM((InputStream)bis, null);
        this.rewriteDOM(doc, input.getURL());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        tidy.pprint(doc, (OutputStream)bos);
        input.setContent(bos.toByteArray());
        return input;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void rewriteDOM(Node node, URL url) throws FilterException {
        if (node == null) {
            throw new FilterException("Got a null node");
        }
        if (node instanceof Element) {
            String name = node.getNodeName();
            if (name.equals("a") || name.equals("area")) {
                this.localizeAttrib(node, "href", url);
            } else if (name.equals("img") || name.equals("frame")) {
                this.localizeAttrib(node, "src", url);
            }
        }
        NodeList childs = node.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            this.rewriteDOM(childs.item(i), url);
        }
    }

    private void localizeAttrib(Node node, String attribute, URL context) {
        Element el = (Element)node;
        String oldValue = el.getAttribute(attribute);
        if (!oldValue.equals("") && oldValue.indexOf("/") != -1) {
            String newValue = this.localizeURL(oldValue, context);
            el.setAttribute(attribute, newValue);
        }
    }

    private String localizeURL(String urlStr, URL context) {
        URL url;
        try {
            url = new URL(context, urlStr);
        }
        catch (MalformedURLException e) {
            return urlStr;
        }
        if (!url.getProtocol().equalsIgnoreCase("http")) {
            return urlStr;
        }
        if (context != null && context.getHost().equalsIgnoreCase(url.getHost())) {
            String ref = url.getRef();
            String path = url.getPath();
            if (path.startsWith("../")) {
                return urlStr;
            }
            if (ref != null && !ref.equals("")) {
                path = path + "#" + ref;
            }
            if (path.length() > 0 && path.charAt(path.length() - 1) == '/') {
                path = path + "index.html";
            }
            return this.localizePath(url.getPath(), context.getPath());
        }
        return urlStr;
    }

    private String localizePath(String path, String context) {
        StringTokenizer st = new StringTokenizer(context, "/");
        int depth = st.countTokens();
        if (!context.endsWith("/")) {
            --depth;
        }
        StringBuffer sb = new StringBuffer();
        if (depth > 0) {
            for (int i = 0; i < depth; ++i) {
                sb.append("/..");
            }
            sb.deleteCharAt(0);
        } else if (path.startsWith("/")) {
            path = path.substring(1);
        }
        sb.append(path);
        return sb.toString();
    }
}

