/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.util;

import java.net.URLEncoder;

public class AttribValuePair {
    private String attrib;
    private String value;
    private boolean ignoreAttribCase = false;

    public void setIgnoreAttribCase(boolean ignore) {
        this.ignoreAttribCase = ignore;
    }

    public boolean getIgnoreAttribCase() {
        return this.ignoreAttribCase;
    }

    public AttribValuePair() {
    }

    public AttribValuePair(String attrib, String value) {
        this.attrib = attrib;
        this.value = value;
    }

    public AttribValuePair(String attribAndValue) {
        this.setAttribAndValue(attribAndValue);
    }

    protected void setAttribAndValue(String attribAndValue) {
        int pos = 0;
        pos = attribAndValue.indexOf("=");
        if (pos == -1) {
            this.attrib = attribAndValue;
        } else {
            this.attrib = attribAndValue.substring(0, pos).trim();
            this.value = attribAndValue.substring(pos + 1).trim();
            if (this.value.startsWith("\"") || this.value.startsWith("'")) {
                this.value = this.value.substring(1);
            }
            if (this.value.endsWith("\"") || this.value.endsWith("'")) {
                this.value = this.value.substring(0, this.value.length() - 1);
            }
        }
    }

    public String getAttrib() {
        if (this.ignoreAttribCase) {
            return this.attrib.toLowerCase();
        }
        return this.attrib;
    }

    public String getValue() {
        return this.value;
    }

    public String toEncodedString() {
        return URLEncoder.encode(this.attrib) + "=" + URLEncoder.encode(this.value);
    }

    public String toString() {
        return this.attrib + "=\"" + this.value + "\"";
    }
}

