/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.util;

public class Base64 {
    private Base64() {
    }

    public static final String encode(byte[] d) {
        int idx;
        if (d == null) {
            return null;
        }
        byte[] data = new byte[d.length + 2];
        System.arraycopy(d, 0, data, 0, d.length);
        byte[] dest = new byte[data.length / 3 * 4];
        int sidx = 0;
        int didx = 0;
        while (sidx < d.length) {
            dest[didx] = (byte)(data[sidx] >>> 2 & 0x3F);
            dest[didx + 1] = (byte)(data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F);
            dest[didx + 2] = (byte)(data[sidx + 2] >>> 6 & 3 | data[sidx + 1] << 2 & 0x3F);
            dest[didx + 3] = (byte)(data[sidx + 2] & 0x3F);
            sidx += 3;
            didx += 4;
        }
        for (idx = 0; idx < dest.length; ++idx) {
            dest[idx] = dest[idx] < 26 ? (int)(dest[idx] + 65) : (dest[idx] < 52 ? (int)(dest[idx] + 97 - 26) : (dest[idx] < 62 ? (int)(dest[idx] + 48 - 52) : (dest[idx] < 63 ? 43 : 47)));
        }
        for (idx = dest.length - 1; idx > d.length * 4 / 3; --idx) {
            dest[idx] = 61;
        }
        return new String(dest);
    }

    public static final String encode(String s) {
        return Base64.encode(s.getBytes());
    }

    public static final byte[] decode(String str) {
        if (str == null) {
            return null;
        }
        byte[] data = str.getBytes();
        return Base64.decode(data);
    }

    public static final byte[] decode(byte[] data) {
        int didx;
        int tail = data.length;
        while (data[tail - 1] == 61) {
            --tail;
        }
        byte[] dest = new byte[tail - data.length / 4];
        for (int idx = 0; idx < data.length; ++idx) {
            if (data[idx] == 61) {
                data[idx] = 0;
                continue;
            }
            if (data[idx] == 47) {
                data[idx] = 63;
                continue;
            }
            if (data[idx] == 43) {
                data[idx] = 62;
                continue;
            }
            if (data[idx] >= 48 && data[idx] <= 57) {
                data[idx] = (byte)(data[idx] - -4);
                continue;
            }
            if (data[idx] >= 97 && data[idx] <= 122) {
                data[idx] = (byte)(data[idx] - 71);
                continue;
            }
            if (data[idx] < 65 || data[idx] > 90) continue;
            data[idx] = (byte)(data[idx] - 65);
        }
        int sidx = 0;
        for (didx = 0; didx < dest.length - 2; didx += 3) {
            dest[didx] = (byte)(data[sidx] << 2 & 0xFF | data[sidx + 1] >>> 4 & 3);
            dest[didx + 1] = (byte)(data[sidx + 1] << 4 & 0xFF | data[sidx + 2] >>> 2 & 0xF);
            dest[didx + 2] = (byte)(data[sidx + 2] << 6 & 0xFF | data[sidx + 3] & 0x3F);
            sidx += 4;
        }
        if (didx < dest.length) {
            dest[didx] = (byte)(data[sidx] << 2 & 0xFF | data[sidx + 1] >>> 4 & 3);
        }
        if (++didx < dest.length) {
            dest[didx] = (byte)(data[sidx + 1] << 4 & 0xFF | data[sidx + 2] >>> 2 & 0xF);
        }
        return dest;
    }

    public static final void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: Base64 string");
            System.exit(0);
        }
        try {
            String e = Base64.encode(args[0].getBytes());
            String d = new String(Base64.decode(e));
            System.out.println("Input   = '" + args[0] + "'");
            System.out.println("Encoded = '" + e + "'");
            System.out.println("Decoded = '" + d + "'");
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

