/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.util;

public class ByteBuffer {
    protected final int INITIALSIZE = 1024;
    protected int used = 0;
    protected int size = 1024;
    protected byte[] buff = new byte[1024];

    public void append(byte b) {
        if (this.used >= this.size) {
            this.doubleBuffer();
        }
        this.buff[this.used] = b;
        ++this.used;
    }

    public int length() {
        return this.used;
    }

    public byte[] getContent() {
        byte[] b = new byte[this.used];
        for (int i = 0; i < this.used; ++i) {
            b[i] = this.buff[i];
        }
        return b;
    }

    public void clean() {
        this.used = 0;
    }

    public void setSize(int size) {
        if (size < this.used) {
            return;
        }
        this.size = size;
        byte[] newBuff = new byte[size];
        for (int i = 0; i < this.used; ++i) {
            newBuff[i] = this.buff[i];
        }
        this.buff = newBuff;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.buff.length);
        for (int i = 0; i < this.used; ++i) {
            sb.append(this.buff[i]);
        }
        return sb.toString();
    }

    protected void doubleBuffer() {
        this.setSize(this.size * 2);
    }
}

