/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import net.matuschek.util.ByteBuffer;

public class ChunkedInputStream
extends FilterInputStream {
    private int contentLength = 0;
    private byte[] b1 = new byte[1];
    private int chunkCount = 0;
    private Vector<String> footerNames = null;
    private Vector<String> footerValues = null;

    public ChunkedInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        if (this.read(this.b1, 0, 1) == -1) {
            return -1;
        }
        return this.b1[0];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int toRead;
        int r;
        if (this.chunkCount == 0) {
            this.startChunk();
            if (this.chunkCount == 0) {
                return -1;
            }
        }
        if ((r = this.in.read(b, off, toRead = Math.min(this.chunkCount, len))) != -1) {
            this.chunkCount -= r;
        }
        return r;
    }

    private void startChunk() throws IOException {
        String line = this.readLine();
        if (line.equals("")) {
            line = this.readLine();
        }
        try {
            this.chunkCount = Integer.parseInt(line.trim(), 16);
        }
        catch (NumberFormatException e) {
            throw new IOException("malformed chunk (" + line + ")");
        }
        this.contentLength += this.chunkCount;
        if (this.chunkCount == 0) {
            this.readFooters();
        }
    }

    private void readFooters() throws IOException {
        String line;
        this.footerNames = new Vector();
        this.footerValues = new Vector();
        while ((line = this.readLine()).length() != 0) {
            int colon = line.indexOf(58);
            if (colon == -1) continue;
            String name = line.substring(0, colon).toLowerCase();
            String value = line.substring(colon + 1).trim();
            this.footerNames.addElement(name.toLowerCase());
            this.footerValues.addElement(value);
        }
    }

    public String getFooter(String name) {
        if (!this.isDone()) {
            return null;
        }
        int i = this.footerNames.indexOf(name.toLowerCase());
        if (i == -1) {
            return null;
        }
        return this.footerValues.elementAt(i);
    }

    public Enumeration getFooters() {
        if (!this.isDone()) {
            return null;
        }
        return this.footerNames.elements();
    }

    public int getContentLength() {
        if (!this.isDone()) {
            return -1;
        }
        return this.contentLength;
    }

    public boolean isDone() {
        return this.footerNames != null;
    }

    protected String readLine() throws IOException {
        int CR = 13;
        int LF = 10;
        ByteBuffer buff = new ByteBuffer();
        byte b = 0;
        int i = 0;
        do {
            if ((b = (byte)this.in.read()) != 10) {
                buff.append(b);
            }
            ++i;
        } while (b != 10);
        byte[] byteBuff = buff.getContent();
        if (byteBuff.length == 0) {
            return "";
        }
        if (byteBuff[byteBuff.length - 1] != 13) {
            return new String(byteBuff);
        }
        return new String(byteBuff, 0, byteBuff.length - 1);
    }
}

