/*
 * Decompiled with CFR 0.152.
 */
package net.matuschek.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedBandwidthStream
extends FilterInputStream {
    private int bandwidth = 0;
    private boolean isReading = false;
    private int count = 0;
    private static int CHECK_INTERVAL = 100;
    long starttime = 0L;
    long usedtime = 0L;

    public LimitedBandwidthStream(InputStream in, int bandwidth) throws IOException {
        super(in);
        this.bandwidth = bandwidth > 0 ? bandwidth : 0;
        this.count = 0;
    }

    public int read() throws IOException {
        if (!this.isReading) {
            this.starttime = System.currentTimeMillis();
            this.isReading = true;
        }
        if (this.bandwidth > 0 && this.count % CHECK_INTERVAL == 0) {
            long currentBandwidth;
            do {
                this.usedtime = System.currentTimeMillis() - this.starttime;
                currentBandwidth = this.usedtime > 0L ? (long)(this.count * 1000) / this.usedtime : 0L;
                if (currentBandwidth <= (long)this.bandwidth) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (currentBandwidth > (long)this.bandwidth);
        }
        ++this.count;
        return super.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int mycount = 0;
        int current = 0;
        if (this.bandwidth > 0) {
            for (int i = off; i < off + len; ++i) {
                current = this.read();
                if (current == -1) {
                    return mycount;
                }
                b[i] = (byte)current;
                ++this.count;
                ++mycount;
            }
            return mycount;
        }
        return this.in.read(b, off, len);
    }
}

