/*
 * Decompiled with CFR 0.152.
 */
package net.olivo.lc4j;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Iterator;
import net.olivo.lc4j.IncrementalInt2IntMap;

public class LanguageModel {
    private Int2IntMap indexMap = new Int2IntOpenHashMap();
    private IntList reverseIndexMap = new IntArrayList();
    private IncrementalInt2IntMap frequencyMap = new IncrementalInt2IntMap();
    private int minFreqSeen;
    private int currSize;

    public LanguageModel() {
        this.indexMap.defaultReturnValue(-1);
        this.frequencyMap.defaultReturnValue(-1);
        this.minFreqSeen = Integer.MAX_VALUE;
        this.currSize = 0;
    }

    public static LanguageModel merge(LanguageModel lang1, LanguageModel lang2, int useTopMostNgrams) {
        ByteArrayList bal;
        int lang1Size = lang1.size();
        int lang2Size = lang2.size();
        LanguageModel languageModel = new LanguageModel();
        IntSet lang1Keys = lang1.keySet();
        IntSet lang2Keys = lang2.keySet();
        IncrementalInt2IntMap hash = new IncrementalInt2IntMap();
        Iterator it = lang1Keys.iterator();
        while (it.hasNext()) {
            bal = (ByteArrayList)it.next();
            hash.inc(bal.hashCode(), lang1.getFreq(bal));
        }
        it = lang2Keys.iterator();
        while (it.hasNext()) {
            bal = (ByteArrayList)it.next();
            hash.inc(bal.hashCode(), lang2.getFreq(bal));
        }
        int[] ngrams = hash.getOrderedKeysByScore();
        int n = useTopMostNgrams > 0 ? Math.min(ngrams.length, useTopMostNgrams) : ngrams.length;
        for (int k = 0; k < n; ++k) {
            try {
                languageModel.add(ngrams[k], hash.get(ngrams[k]));
                continue;
            }
            catch (IllegalArgumentException e) {
                System.err.println(e);
                System.err.println("WARNING: resulting language-model will be very likely invalid!");
                break;
            }
        }
        return languageModel;
    }

    public void add(int ngram, int freq) throws IllegalArgumentException {
        if (freq > this.minFreqSeen) {
            throw new IllegalArgumentException("Given n-gram frequency has a frequency greater than that of the previous element.");
        }
        if (this.indexMap.get(ngram) != -1) {
            throw new IllegalArgumentException("Given n-gram has already been added to this language-model.");
        }
        this.minFreqSeen = freq;
        int newIndex = this.currSize++;
        this.indexMap.put(ngram, newIndex);
        this.reverseIndexMap.add(ngram);
        this.frequencyMap.set(newIndex, freq);
    }

    public int size() {
        return this.currSize;
    }

    public IntSet keySet() {
        return (IntSet)this.indexMap.keySet();
    }

    public boolean contains(int ngram) {
        return this.indexMap.containsKey(ngram);
    }

    public int getNgram(int index) {
        return this.reverseIndexMap.getInt(index);
    }

    public int getPos(int ngram) {
        return this.indexMap.get(ngram);
    }

    public int getFreq(int index) {
        return this.frequencyMap.get(index);
    }

    public int getFreq(ByteArrayList ngram) {
        return this.getFreq(this.getPos(ngram.hashCode()));
    }
}

