/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.actor.Actor$;
import akka.actor.ActorRef;
import akka.actor.IllegalActorStateException;
import akka.actor.Scheduler$;
import akka.dispatch.Dispatchers$;
import akka.dispatch.MessageDispatcher;
import akka.dispatch.MessageDispatcher$;
import akka.dispatch.MessageInvocation;
import akka.dispatch.MessageQueue;
import akka.util.ReentrantGuard;
import akka.util.ReflectiveAccess$;
import akka.util.Switch;
import com.eaio.uuid.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.NoManifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class MessageDispatcher$class {
    public static MessageQueue createMailbox(MessageDispatcher $this, String mailboxImplClassname$1, ActorRef actorRef$3) {
        return (MessageQueue)ReflectiveAccess$.MODULE$.createInstance(mailboxImplClassname$1, (Class[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ActorRef.class}), ClassManifest$.MODULE$.classType(Class.class, (OptManifest)NoManifest$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[0]))), (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ActorRef[]{actorRef$3}), ClassManifest$.MODULE$.classType(ActorRef.class)), ReflectiveAccess$.MODULE$.loader()).getOrElse((Function0)new MessageDispatcher$.anonfun.createMailbox.1($this, mailboxImplClassname$1, actorRef$3));
    }

    public static final void attach(MessageDispatcher $this, ActorRef actorRef$1) {
        $this.guard().withGuard(new MessageDispatcher$.anonfun.attach.1($this, actorRef$1));
    }

    public static final void detach(MessageDispatcher $this, ActorRef actorRef$2) {
        $this.guard().withGuard(new MessageDispatcher$.anonfun.detach.1($this, actorRef$2));
    }

    public static final void dispatchMessage(MessageDispatcher $this, MessageInvocation invocation) {
        if ($this.active().isOn()) {
            $this.dispatch(invocation);
            return;
        }
        throw new IllegalActorStateException("Can't submit invocations to dispatcher since it's not started");
    }

    public static void register(MessageDispatcher $this, ActorRef actorRef) {
        Object object = actorRef.mailbox() == null ? actorRef.mailbox_$eq($this.createMailbox(actorRef)) : BoxedUnit.UNIT;
        $this.uuids().add(actorRef.uuid());
        if ($this.active().isOff()) {
            $this.active().switchOn((Function0<Object>)new MessageDispatcher$.anonfun.register.1($this));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object unregister(MessageDispatcher $this, ActorRef actorRef) {
        Object object;
        if ($this.uuids().remove(actorRef.uuid())) {
            actorRef.mailbox_$eq(null);
            if ($this.uuids().isEmpty()) {
                int n = $this.akka$dispatch$MessageDispatcher$$shutdownSchedule();
                if (n == MessageDispatcher$.MODULE$.UNSCHEDULED()) {
                    $this.akka$dispatch$MessageDispatcher$$shutdownSchedule_$eq(MessageDispatcher$.MODULE$.SCHEDULED());
                    object = Scheduler$.MODULE$.scheduleOnce($this.akka$dispatch$MessageDispatcher$$shutdownAction(), $this.timeoutMs(), TimeUnit.MILLISECONDS);
                    return object;
                } else if (n == MessageDispatcher$.MODULE$.SCHEDULED()) {
                    $this.akka$dispatch$MessageDispatcher$$shutdownSchedule_$eq(MessageDispatcher$.MODULE$.RESCHEDULED());
                    object = BoxedUnit.UNIT;
                    return object;
                } else {
                    if (n != MessageDispatcher$.MODULE$.RESCHEDULED()) throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    object = BoxedUnit.UNIT;
                }
                return object;
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        } else {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public static void stopAllAttachedActors(MessageDispatcher $this) {
        for (UUID uuid : $this.uuids()) {
            Option<ActorRef> option = Actor$.MODULE$.registry().actorFor(uuid);
            if (option instanceof Some) {
                ((ActorRef)((Some)option).x()).stop();
                continue;
            }
            None$ none$ = None$.MODULE$;
            Option<ActorRef> option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                $this.log().slf4j().error(new StringBuilder().append((Object)"stopAllLinkedActors couldn't find linked actor: ").append((Object)uuid).toString());
                continue;
            }
            throw new MatchError(option);
        }
    }

    public static long timeoutMs(MessageDispatcher $this) {
        return Dispatchers$.MODULE$.DEFAULT_SHUTDOWN_TIMEOUT().toMillis();
    }

    public static void $init$(MessageDispatcher $this) {
        $this.akka$dispatch$MessageDispatcher$_setter_$uuids_$eq(new ConcurrentSkipListSet());
        $this.akka$dispatch$MessageDispatcher$_setter_$guard_$eq(new ReentrantGuard());
        $this.akka$dispatch$MessageDispatcher$_setter_$active_$eq(new Switch(false));
        $this.akka$dispatch$MessageDispatcher$$shutdownSchedule_$eq(MessageDispatcher$.MODULE$.UNSCHEDULED());
        $this.akka$dispatch$MessageDispatcher$_setter_$akka$dispatch$MessageDispatcher$$shutdownAction_$eq(new MessageDispatcher$.anon.1($this));
    }
}

