/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.Actor;
import akka.actor.Actor$;
import akka.actor.ActorRef;
import akka.actor.ActorRef$;
import akka.actor.ActorRefInternals;
import akka.actor.ActorRefInternals$BEING_RESTARTED$;
import akka.actor.ActorRefInternals$RUNNING$;
import akka.actor.ActorRefInternals$SHUTDOWN$;
import akka.actor.ActorRefInternals$UNSTARTED$;
import akka.actor.ReceiveTimeout$;
import akka.actor.ScalaActorRef;
import akka.actor.Scheduler$;
import akka.actor.package$;
import akka.dispatch.MessageDispatcher;
import akka.util.HashCode$;
import akka.util.ReentrantGuard;
import com.eaio.uuid.UUID;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Stack;
import scala.collection.immutable.Stack$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public abstract class ActorRef$class {
    public static void setId(ActorRef $this, String string) {
        $this.id_$eq(string);
    }

    public static void setTimeout(ActorRef $this, long l) {
        $this.timeout_$eq(l);
    }

    public static void setReceiveTimeout(ActorRef $this, long timeout) {
        $this.receiveTimeout_$eq((Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)timeout)));
    }

    public static Option getReceiveTimeout(ActorRef $this) {
        return $this.receiveTimeout();
    }

    public static void setDispatcher(ActorRef $this, MessageDispatcher dispatcher) {
        $this.dispatcher_$eq(dispatcher);
    }

    public static MessageDispatcher getDispatcher(ActorRef $this) {
        return $this.dispatcher();
    }

    public static InetSocketAddress getHomeAddress(ActorRef $this) {
        return (InetSocketAddress)$this.homeAddress().getOrElse((Function0)new ActorRef$.anonfun.getHomeAddress.1($this));
    }

    public static int compareTo(ActorRef $this, ActorRef other) {
        return $this.uuid().compareTo(other.uuid());
    }

    public static UUID getUuid(ActorRef $this) {
        return $this._uuid();
    }

    public static UUID uuid(ActorRef $this) {
        return $this._uuid();
    }

    public static Option getSender(ActorRef $this) {
        return ((ScalaActorRef)((Object)$this)).sender();
    }

    public static Option getSenderFuture(ActorRef $this) {
        return ((ScalaActorRef)((Object)$this)).senderFuture();
    }

    public static boolean isBeingRestarted(ActorRef $this) {
        ActorRefInternals.StatusType statusType = $this._status();
        ActorRefInternals$BEING_RESTARTED$ actorRefInternals$BEING_RESTARTED$ = ActorRefInternals$BEING_RESTARTED$.MODULE$;
        return !(statusType != null ? !statusType.equals(actorRefInternals$BEING_RESTARTED$) : actorRefInternals$BEING_RESTARTED$ != null);
    }

    public static boolean isRunning(ActorRef $this) {
        boolean bl;
        ActorRefInternals.StatusType statusType = $this._status();
        ActorRefInternals$BEING_RESTARTED$ actorRefInternals$BEING_RESTARTED$ = ActorRefInternals$BEING_RESTARTED$.MODULE$;
        ActorRefInternals.StatusType statusType2 = statusType;
        if (!(actorRefInternals$BEING_RESTARTED$ != null ? !actorRefInternals$BEING_RESTARTED$.equals(statusType2) : statusType2 != null)) {
            bl = true;
        } else {
            ActorRefInternals$RUNNING$ actorRefInternals$RUNNING$ = ActorRefInternals$RUNNING$.MODULE$;
            ActorRefInternals.StatusType statusType3 = statusType;
            bl = !(actorRefInternals$RUNNING$ != null ? !actorRefInternals$RUNNING$.equals(statusType3) : statusType3 != null);
        }
        return bl;
    }

    public static boolean isShutdown(ActorRef $this) {
        ActorRefInternals.StatusType statusType = $this._status();
        ActorRefInternals$SHUTDOWN$ actorRefInternals$SHUTDOWN$ = ActorRefInternals$SHUTDOWN$.MODULE$;
        return !(statusType != null ? !statusType.equals(actorRefInternals$SHUTDOWN$) : actorRefInternals$SHUTDOWN$ != null);
    }

    public static boolean isUnstarted(ActorRef $this) {
        ActorRefInternals.StatusType statusType = $this._status();
        ActorRefInternals$UNSTARTED$ actorRefInternals$UNSTARTED$ = ActorRefInternals$UNSTARTED$.MODULE$;
        return !(statusType != null ? !statusType.equals(actorRefInternals$UNSTARTED$) : actorRefInternals$UNSTARTED$ != null);
    }

    public static boolean isDefinedAt(ActorRef $this, Object message) {
        return $this.actor().isDefinedAt(message);
    }

    public static void uuid_$eq(ActorRef $this, UUID uid) {
        $this._uuid_$eq(uid);
    }

    public static void sendOneWay(ActorRef $this, Object message) {
        $this.sendOneWay(message, null);
    }

    public static void sendOneWay(ActorRef $this, Object message, ActorRef sender) {
        ((ScalaActorRef)((Object)$this)).$bang(message, (Option<ActorRef>)Option$.MODULE$.apply((Object)sender));
    }

    public static Object sendRequestReply(ActorRef $this, Object message) {
        return $this.sendRequestReply(message, $this.timeout(), null);
    }

    public static Object sendRequestReply(ActorRef $this, Object message, ActorRef sender) {
        return $this.sendRequestReply(message, $this.timeout(), sender);
    }

    public static Object sendRequestReply(ActorRef $this, Object message$1, long timeout$1, ActorRef sender$1) {
        return ((ScalaActorRef)((Object)$this)).$bang$bang(message$1, timeout$1, (Option<ActorRef>)Option$.MODULE$.apply((Object)sender$1)).getOrElse((Function0)new ActorRef$.anonfun.sendRequestReply.1($this, message$1, timeout$1, sender$1));
    }

    public static akka.dispatch.Future sendRequestReplyFuture(ActorRef $this, Object message) {
        return $this.sendRequestReplyFuture(message, $this.timeout(), null);
    }

    public static akka.dispatch.Future sendRequestReplyFuture(ActorRef $this, Object message, ActorRef sender) {
        return $this.sendRequestReplyFuture(message, $this.timeout(), sender);
    }

    public static akka.dispatch.Future sendRequestReplyFuture(ActorRef $this, Object message, long timeout, ActorRef sender) {
        return ((ScalaActorRef)((Object)$this)).$bang$bang$bang(message, timeout, (Option<ActorRef>)Option$.MODULE$.apply((Object)sender));
    }

    public static void forward(ActorRef $this, Object message, ActorRef sender) {
        if (sender == null) {
            throw new IllegalArgumentException("The 'sender' argument to 'forward' can't be null");
        }
        ((ScalaActorRef)((Object)$this)).forward(message, (Some<ActorRef>)new Some((Object)sender));
    }

    public static void replyUnsafe(ActorRef $this, Object message) {
        ((ScalaActorRef)((Object)$this)).reply(message);
    }

    public static boolean replySafe(ActorRef $this, Object message) {
        return ((ScalaActorRef)((Object)$this)).reply_$qmark(message);
    }

    public static Class getActorClass(ActorRef $this) {
        return $this.actorClass();
    }

    public static String getActorClassName(ActorRef $this) {
        return $this.actorClassName();
    }

    public static void exit(ActorRef $this) {
        $this.stop();
    }

    public static int mailboxSize(ActorRef $this) {
        return $this.dispatcher().mailboxSize($this);
    }

    public static int getMailboxSize(ActorRef $this) {
        return $this.mailboxSize();
    }

    public static ActorRef getSupervisor(ActorRef $this) {
        return (ActorRef)$this.supervisor().getOrElse((Function0)new ActorRef$.anonfun.getSupervisor.1($this));
    }

    public static Actor actor(ActorRef $this) {
        return $this.actorInstance().get();
    }

    public static int hashCode(ActorRef $this) {
        return HashCode$.MODULE$.hash(HashCode$.MODULE$.SEED(), $this.uuid());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equals(ActorRef $this, Object that) {
        if (!(that instanceof ActorRef)) return false;
        UUID uUID = ((ActorRef)that).uuid();
        UUID uUID2 = $this.uuid();
        if (uUID != null) {
            if (!uUID.equals(uUID2)) return false;
            return true;
        }
        if (uUID2 == null) return true;
        return false;
    }

    public static String toString(ActorRef $this) {
        return new StringBuilder().append((Object)"Actor[").append((Object)$this.id()).append((Object)":").append((Object)$this.uuid()).append((Object)"]").toString();
    }

    public static void checkReceiveTimeout(ActorRef $this) {
        $this.cancelReceiveTimeout();
        if ($this.receiveTimeout().isDefined() && $this.dispatcher().mailboxSize($this) <= 0) {
            Actor$.MODULE$.log().slf4j().debug("Scheduling timeout for {}", (Object)$this);
            $this._futureTimeout_$eq((Option<ScheduledFuture<Object>>)new Some(Scheduler$.MODULE$.scheduleOnce($this, ReceiveTimeout$.MODULE$, BoxesRunTime.unboxToLong((Object)$this.receiveTimeout().get()), TimeUnit.MILLISECONDS)));
        }
    }

    public static void cancelReceiveTimeout(ActorRef $this) {
        if ($this._futureTimeout().isDefined()) {
            ((Future)$this._futureTimeout().get()).cancel(true);
            $this._futureTimeout_$eq((Option<ScheduledFuture<Object>>)None$.MODULE$);
            Actor$.MODULE$.log().slf4j().debug("Timeout canceled for {}", (Object)$this);
        }
    }

    public static long getTimeout(ActorRef $this) {
        return $this.timeout();
    }

    public static String getId(ActorRef $this) {
        return $this.id();
    }

    public static void $init$(ActorRef $this) {
        $this._uuid_$eq(package$.MODULE$.newUuid());
        $this._status_$eq(ActorRefInternals$UNSTARTED$.MODULE$);
        $this._futureTimeout_$eq((Option<ScheduledFuture<Object>>)None$.MODULE$);
        $this.akka$actor$ActorRef$_setter_$guard_$eq(new ReentrantGuard());
        $this.id_$eq($this._uuid().toString());
        $this.timeout_$eq(Actor$.MODULE$.TIMEOUT());
        $this.receiveTimeout_$eq((Option<Long>)None$.MODULE$);
        $this.hotswap_$eq((Stack<PartialFunction<Object, Object>>)((Stack)Stack$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartialFunction[0]))));
        $this.currentMessage_$eq(null);
    }
}

