/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.uuid;

import com.eaio.util.lang.Hex;
import com.eaio.uuid.MACAddressParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicLong;

public final class UUIDGen {
    private static final AtomicLong lastTime;
    private static String macAddress;
    private static long clockSeqAndNode;

    private UUIDGen() {
    }

    public static long getClockSeqAndNode() {
        return clockSeqAndNode;
    }

    public static long newTime() {
        return UUIDGen.createTime(System.currentTimeMillis());
    }

    public static long createTime(long l) {
        long l2;
        long l3 = l * 10000L + 122192928000000000L;
        do {
            if (l3 > (l2 = lastTime.get())) continue;
            l3 = lastTime.incrementAndGet();
            break;
        } while (!lastTime.compareAndSet(l2, l3));
        long l4 = l3 << 32;
        l4 |= (l3 & 0xFFFF00000000L) >> 16;
        return l4 |= 0x1000L | l3 >> 48 & 0xFFFL;
    }

    public static String getMACAddress() {
        return macAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getFirstLineOfCommand(String ... stringArray) throws IOException {
        Process process = null;
        BufferedReader bufferedReader = null;
        try {
            process = Runtime.getRuntime().exec(stringArray);
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 128);
            String string = bufferedReader.readLine();
            return string;
        }
        finally {
            if (process != null) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    process.getErrorStream().close();
                }
                catch (IOException iOException) {}
                try {
                    process.getOutputStream().close();
                }
                catch (IOException iOException) {}
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object;
        lastTime = new AtomicLong(Long.MIN_VALUE);
        macAddress = null;
        clockSeqAndNode = Long.MIN_VALUE;
        try {
            Class.forName("java.net.InterfaceAddress");
            macAddress = Class.forName("com.eaio.uuid.UUIDGen$HardwareAddressLookup").newInstance().toString();
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (macAddress == null) {
            object = null;
            BufferedReader bufferedReader = null;
            try {
                String string;
                String string2 = System.getProperty("os.name", "");
                if (string2.startsWith("Windows")) {
                    object = Runtime.getRuntime().exec(new String[]{"ipconfig", "/all"}, null);
                } else if (string2.startsWith("Solaris") || string2.startsWith("SunOS")) {
                    string = UUIDGen.getFirstLineOfCommand("uname", "-n");
                    if (string != null) {
                        object = Runtime.getRuntime().exec(new String[]{"/usr/sbin/arp", string}, null);
                    }
                } else if (new File("/usr/sbin/lanscan").exists()) {
                    object = Runtime.getRuntime().exec(new String[]{"/usr/sbin/lanscan"}, null);
                } else if (new File("/sbin/ifconfig").exists()) {
                    object = Runtime.getRuntime().exec(new String[]{"/sbin/ifconfig", "-a"}, null);
                }
                if (object != null) {
                    bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()), 128);
                    string = null;
                    while ((string = bufferedReader.readLine()) != null && ((macAddress = MACAddressParser.parse(string)) == null || Hex.parseShort(macAddress) == 255)) {
                    }
                }
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
            }
            finally {
                if (object != null) {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    try {
                        ((Process)object).getErrorStream().close();
                    }
                    catch (IOException iOException) {}
                    try {
                        ((Process)object).getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                    ((Process)object).destroy();
                }
            }
        }
        if (macAddress != null) {
            clockSeqAndNode |= Hex.parseLong(macAddress);
        } else {
            try {
                object = InetAddress.getLocalHost().getAddress();
                clockSeqAndNode |= (long)(object[0] << 24) & 0xFF000000L;
                clockSeqAndNode |= (long)(object[1] << 16 & 0xFF0000);
                clockSeqAndNode |= (long)(object[2] << 8 & 0xFF00);
                clockSeqAndNode |= (long)(object[3] & 0xFF);
            }
            catch (UnknownHostException unknownHostException) {
                clockSeqAndNode |= (long)(Math.random() * 2.147483647E9);
            }
        }
        clockSeqAndNode |= (long)(Math.random() * 16383.0) << 48;
    }

    static class HardwareAddressLookup {
        HardwareAddressLookup() {
        }

        public String toString() {
            String string;
            block3: {
                string = null;
                try {
                    Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                    if (enumeration == null) break block3;
                    while (enumeration.hasMoreElements()) {
                        NetworkInterface networkInterface = enumeration.nextElement();
                        byte[] byArray = networkInterface.getHardwareAddress();
                        if (byArray == null || byArray.length != 6 || byArray[1] == -1) continue;
                        string = Hex.append((Appendable)new StringBuilder(36), byArray).toString();
                        break;
                    }
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
            return string;
        }
    }
}

