/*
 * Decompiled with CFR 0.152.
 */
package se.scalablesolutions.akka.actor;

import com.eaio.uuid.UUID;
import java.net.InetSocketAddress;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Stack;
import scala.collection.immutable.Stack$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import se.scalablesolutions.akka.actor.Actor;
import se.scalablesolutions.akka.actor.Actor$;
import se.scalablesolutions.akka.actor.ActorRef;
import se.scalablesolutions.akka.actor.ActorRef$;
import se.scalablesolutions.akka.actor.ActorRefInternals;
import se.scalablesolutions.akka.actor.ActorRefInternals$;
import se.scalablesolutions.akka.actor.ActorRefInternals$BEING_RESTARTED$;
import se.scalablesolutions.akka.actor.ActorRefInternals$RUNNING$;
import se.scalablesolutions.akka.actor.ActorRefInternals$SHUTDOWN$;
import se.scalablesolutions.akka.actor.ActorRefInternals$UNSTARTED$;
import se.scalablesolutions.akka.actor.ReceiveTimeout$;
import se.scalablesolutions.akka.actor.ScalaActorRef;
import se.scalablesolutions.akka.actor.Scheduler$;
import se.scalablesolutions.akka.actor.package$;
import se.scalablesolutions.akka.dispatch.Dispatchers$;
import se.scalablesolutions.akka.dispatch.Future;
import se.scalablesolutions.akka.dispatch.MessageDispatcher;
import se.scalablesolutions.akka.stm.TransactionConfig;
import se.scalablesolutions.akka.util.HashCode$;
import se.scalablesolutions.akka.util.ReentrantGuard;
import se.scalablesolutions.akka.util.ReflectiveAccess$RemoteServerModule$;

public abstract class ActorRef$class {
    public static void setId(ActorRef $this, String string) {
        $this.id_$eq(string);
    }

    public static void setTimeout(ActorRef $this, long l) {
        $this.timeout_$eq(l);
    }

    public static void setReceiveTimeout(ActorRef $this, long timeout) {
        $this.receiveTimeout_$eq((Option<Long>)new Some((Object)BoxesRunTime.boxToLong((long)timeout)));
    }

    public static Option getReceiveTimeout(ActorRef $this) {
        return $this.receiveTimeout();
    }

    public static void setDispatcher(ActorRef $this, MessageDispatcher dispatcher) {
        $this.dispatcher_$eq(dispatcher);
    }

    public static MessageDispatcher getDispatcher(ActorRef $this) {
        return $this.dispatcher();
    }

    public static boolean isTransactor(ActorRef $this) {
        ActorRefInternals.TransactorConfig c = $this.transactorConfig();
        return c != ActorRefInternals$.MODULE$.NoTransactionConfig() && c != null;
    }

    public static int compareTo(ActorRef $this, ActorRef other) {
        return $this.uuid().compareTo(other.uuid());
    }

    public static UUID getUuid(ActorRef $this) {
        return $this._uuid();
    }

    public static UUID uuid(ActorRef $this) {
        return $this._uuid();
    }

    public static Option getSender(ActorRef $this) {
        return ((ScalaActorRef)((Object)$this)).sender();
    }

    public static Option getSenderFuture(ActorRef $this) {
        return ((ScalaActorRef)((Object)$this)).senderFuture();
    }

    public static boolean isBeingRestarted(ActorRef $this) {
        ActorRefInternals.StatusType statusType = $this._status();
        ActorRefInternals$BEING_RESTARTED$ actorRefInternals$BEING_RESTARTED$ = ActorRefInternals$BEING_RESTARTED$.MODULE$;
        return !(statusType != null ? !statusType.equals(actorRefInternals$BEING_RESTARTED$) : actorRefInternals$BEING_RESTARTED$ != null);
    }

    public static boolean isRunning(ActorRef $this) {
        boolean bl;
        ActorRefInternals.StatusType statusType = $this._status();
        ActorRefInternals$BEING_RESTARTED$ actorRefInternals$BEING_RESTARTED$ = ActorRefInternals$BEING_RESTARTED$.MODULE$;
        ActorRefInternals.StatusType statusType2 = statusType;
        if (!(actorRefInternals$BEING_RESTARTED$ != null ? !actorRefInternals$BEING_RESTARTED$.equals(statusType2) : statusType2 != null)) {
            bl = true;
        } else {
            ActorRefInternals$RUNNING$ actorRefInternals$RUNNING$ = ActorRefInternals$RUNNING$.MODULE$;
            ActorRefInternals.StatusType statusType3 = statusType;
            bl = !(actorRefInternals$RUNNING$ != null ? !actorRefInternals$RUNNING$.equals(statusType3) : statusType3 != null);
        }
        return bl;
    }

    public static boolean isShutdown(ActorRef $this) {
        ActorRefInternals.StatusType statusType = $this._status();
        ActorRefInternals$SHUTDOWN$ actorRefInternals$SHUTDOWN$ = ActorRefInternals$SHUTDOWN$.MODULE$;
        return !(statusType != null ? !statusType.equals(actorRefInternals$SHUTDOWN$) : actorRefInternals$SHUTDOWN$ != null);
    }

    public static boolean isUnstarted(ActorRef $this) {
        ActorRefInternals.StatusType statusType = $this._status();
        ActorRefInternals$UNSTARTED$ actorRefInternals$UNSTARTED$ = ActorRefInternals$UNSTARTED$.MODULE$;
        return !(statusType != null ? !statusType.equals(actorRefInternals$UNSTARTED$) : actorRefInternals$UNSTARTED$ != null);
    }

    public static boolean isDefinedAt(ActorRef $this, Object message) {
        return $this.actor().isDefinedAt(message);
    }

    public static void uuid_$eq(ActorRef $this, UUID uid) {
        $this._uuid_$eq(uid);
    }

    public static void sendOneWay(ActorRef $this, Object message) {
        $this.sendOneWay(message, null);
    }

    public static void sendOneWay(ActorRef $this, Object message, ActorRef sender) {
        ((ScalaActorRef)((Object)$this)).$bang(message, (Option<ActorRef>)Option$.MODULE$.apply((Object)sender));
    }

    public static Object sendRequestReply(ActorRef $this, Object message) {
        return $this.sendRequestReply(message, $this.timeout(), null);
    }

    public static Object sendRequestReply(ActorRef $this, Object message, ActorRef sender) {
        return $this.sendRequestReply(message, $this.timeout(), sender);
    }

    public static Object sendRequestReply(ActorRef $this, Object message$1, long timeout$1, ActorRef sender$1) {
        return ((ScalaActorRef)((Object)$this)).$bang$bang(message$1, timeout$1, (Option<ActorRef>)Option$.MODULE$.apply((Object)sender$1)).getOrElse((Function0)new ActorRef$.anonfun.sendRequestReply.1($this, message$1, timeout$1, sender$1));
    }

    public static Future sendRequestReplyFuture(ActorRef $this, Object message) {
        return $this.sendRequestReplyFuture(message, $this.timeout(), null);
    }

    public static Future sendRequestReplyFuture(ActorRef $this, Object message, ActorRef sender) {
        return $this.sendRequestReplyFuture(message, $this.timeout(), sender);
    }

    public static Future sendRequestReplyFuture(ActorRef $this, Object message, long timeout, ActorRef sender) {
        return ((ScalaActorRef)((Object)$this)).$bang$bang$bang(message, timeout, (Option<ActorRef>)Option$.MODULE$.apply((Object)sender));
    }

    public static void forward(ActorRef $this, Object message, ActorRef sender) {
        if (sender == null) {
            throw new IllegalArgumentException("The 'sender' argument to 'forward' can't be null");
        }
        ((ScalaActorRef)((Object)$this)).forward(message, (Some<ActorRef>)new Some((Object)sender));
    }

    public static void replyUnsafe(ActorRef $this, Object message) {
        ((ScalaActorRef)((Object)$this)).reply(message);
    }

    public static boolean replySafe(ActorRef $this, Object message) {
        return ((ScalaActorRef)((Object)$this)).reply_$qmark(message);
    }

    public static Class getActorClass(ActorRef $this) {
        return $this.actorClass();
    }

    public static String getActorClassName(ActorRef $this) {
        return $this.actorClassName();
    }

    public static void setTransactionConfig(ActorRef $this, TransactionConfig config) {
        $this.transactionConfig_$eq(config);
    }

    public static TransactionConfig getTransactionConfig(ActorRef $this) {
        return $this.transactionConfig();
    }

    public static InetSocketAddress homeAddress(ActorRef $this) {
        return $this._homeAddress();
    }

    public static InetSocketAddress getHomeAddress(ActorRef $this) {
        return $this.homeAddress();
    }

    public static void homeAddress_$eq(ActorRef $this, Tuple2 hostnameAndPort) {
        $this.homeAddress_$eq(new InetSocketAddress((String)hostnameAndPort._1(), hostnameAndPort._2$mcI$sp()));
    }

    public static void setHomeAddress(ActorRef $this, String hostname, int port) {
        $this.homeAddress_$eq((Tuple2<String, Integer>)new Tuple2((Object)hostname, (Object)BoxesRunTime.boxToInteger((int)port)));
    }

    public static void setHomeAddress(ActorRef $this, InetSocketAddress address) {
        $this.homeAddress_$eq(address);
    }

    public static Option getRemoteAddress(ActorRef $this) {
        return $this.remoteAddress();
    }

    public static void exit(ActorRef $this) {
        $this.stop();
    }

    public static int mailboxSize(ActorRef $this) {
        return $this.dispatcher().mailboxSize($this);
    }

    public static int getMailboxSize(ActorRef $this) {
        return $this.mailboxSize();
    }

    public static ActorRef getSupervisor(ActorRef $this) {
        return (ActorRef)$this.supervisor().getOrElse((Function0)new ActorRef$.anonfun.getSupervisor.1($this));
    }

    public static Actor actor(ActorRef $this) {
        return $this.actorInstance().get();
    }

    public static int hashCode(ActorRef $this) {
        return HashCode$.MODULE$.hash(HashCode$.MODULE$.SEED(), $this.uuid());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equals(ActorRef $this, Object that) {
        if (!(that instanceof ActorRef)) return false;
        UUID uUID = ((ActorRef)that).uuid();
        UUID uUID2 = $this.uuid();
        if (uUID != null) {
            if (!uUID.equals(uUID2)) return false;
            return true;
        }
        if (uUID2 == null) return true;
        return false;
    }

    public static String toString(ActorRef $this) {
        return new StringBuilder().append((Object)"Actor[").append((Object)$this.id()).append((Object)":").append((Object)$this.uuid()).append((Object)"]").toString();
    }

    public static void checkReceiveTimeout(ActorRef $this) {
        $this.cancelReceiveTimeout();
        if ($this.receiveTimeout().isDefined() && $this.dispatcher().mailboxSize($this) <= 0) {
            $this.log().debug((Function0<String>)new ActorRef$.anonfun.checkReceiveTimeout.1($this), $this, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            $this._futureTimeout_$eq((Option<ScheduledFuture<Object>>)new Some(Scheduler$.MODULE$.scheduleOnce($this, ReceiveTimeout$.MODULE$, BoxesRunTime.unboxToLong((Object)$this.receiveTimeout().get()), TimeUnit.MILLISECONDS)));
        }
    }

    public static void cancelReceiveTimeout(ActorRef $this) {
        if ($this._futureTimeout().isDefined()) {
            ((java.util.concurrent.Future)$this._futureTimeout().get()).cancel(true);
            $this._futureTimeout_$eq((Option<ScheduledFuture<Object>>)None$.MODULE$);
            $this.log().debug((Function0<String>)new ActorRef$.anonfun.cancelReceiveTimeout.1($this), $this, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
    }

    public static long getTimeout(ActorRef $this) {
        return $this.timeout();
    }

    public static String getId(ActorRef $this) {
        return $this.id();
    }

    public static void $init$(ActorRef $this) {
        $this._uuid_$eq(package$.MODULE$.newUuid());
        $this._status_$eq(ActorRefInternals$UNSTARTED$.MODULE$);
        $this._homeAddress_$eq(new InetSocketAddress(ReflectiveAccess$RemoteServerModule$.MODULE$.HOSTNAME(), ReflectiveAccess$RemoteServerModule$.MODULE$.PORT()));
        $this._futureTimeout_$eq((Option<ScheduledFuture<Object>>)None$.MODULE$);
        $this.se$scalablesolutions$akka$actor$ActorRef$_setter_$guard_$eq(new ReentrantGuard());
        $this.id_$eq($this._uuid().toString());
        $this.timeout_$eq(Actor$.MODULE$.TIMEOUT());
        $this.receiveTimeout_$eq((Option<Long>)None$.MODULE$);
        $this._dispatcher_$eq(Dispatchers$.MODULE$.defaultGlobalDispatcher());
        $this.hotswap_$eq((Stack<PartialFunction<Object, Object>>)((Stack)Stack$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartialFunction[0]))));
        $this.transactorConfig_$eq(ActorRefInternals$.MODULE$.NoTransactionConfig());
        $this.currentMessage_$eq(null);
    }
}

