/*
 * Decompiled with CFR 0.152.
 */
package se.scalablesolutions.akka.dispatch;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import se.scalablesolutions.akka.actor.IllegalActorStateException;
import se.scalablesolutions.akka.dispatch.ThreadPoolBuilder;
import se.scalablesolutions.akka.dispatch.ThreadPoolBuilder$;

public abstract class ThreadPoolBuilder$class {
    public static final ThreadPoolBuilder.MonitorableThreadFactory se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadFactory(ThreadPoolBuilder $this) {
        return new ThreadPoolBuilder.MonitorableThreadFactory($this, $this.name());
    }

    public static boolean isShutdown(ThreadPoolBuilder $this) {
        return $this.executor().isShutdown();
    }

    public static void buildThreadPool(ThreadPoolBuilder $this) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            BoxedUnit boxedUnit;
            $this.ensureNotActive();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$inProcessOfBuilding_$eq(false);
            $this.log().debug((Function0<String>)new ThreadPoolBuilder$.anonfun.buildThreadPool.1($this), $this.getClass().getName(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder().getCorePoolSize()), BoxesRunTime.boxToInteger((int)$this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder().getMaximumPoolSize()), BoxesRunTime.boxToLong((long)$this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder().getKeepAliveTime($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$MILLISECONDS())), BoxesRunTime.boxToBoolean((boolean)$this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder().allowsCoreThreadTimeOut()), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder().getRejectedExecutionHandler().getClass().getSimpleName()}));
            if ($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$boundedExecutorBound() > 0) {
                ThreadPoolBuilder.BoundedExecutorDecorator boundedExecutor = new ThreadPoolBuilder.BoundedExecutorDecorator($this, $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$boundedExecutorBound());
                $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$boundedExecutorBound_$eq(-1);
                $this.executor_$eq(boundedExecutor);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.executor_$eq($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder());
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public static ThreadPoolBuilder withNewThreadPoolWithCustomBlockingQueue(ThreadPoolBuilder $this, BlockingQueue queue) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.ensureNotActive();
            $this.verifyNotInConstructionPhase();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue_$eq(queue);
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder_$eq(new ThreadPoolExecutor($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_START_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_MAX_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$KEEP_ALIVE_TIME(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$MILLISECONDS(), queue));
            ThreadPoolBuilder threadPoolBuilder2 = $this;
            return threadPoolBuilder2;
        }
    }

    public static ThreadPoolBuilder withNewBoundedThreadPoolWithLinkedBlockingQueueWithUnboundedCapacity(ThreadPoolBuilder $this, int bound) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.ensureNotActive();
            $this.verifyNotInConstructionPhase();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue_$eq(new LinkedBlockingQueue());
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder_$eq(new ThreadPoolExecutor($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_START_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_MAX_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$KEEP_ALIVE_TIME(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$MILLISECONDS(), (BlockingQueue<Runnable>)$this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadFactory()));
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$boundedExecutorBound_$eq(bound);
            ThreadPoolBuilder threadPoolBuilder2 = $this;
            return threadPoolBuilder2;
        }
    }

    public static ThreadPoolBuilder withNewThreadPoolWithLinkedBlockingQueueWithUnboundedCapacity(ThreadPoolBuilder $this) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.ensureNotActive();
            $this.verifyNotInConstructionPhase();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue_$eq(new LinkedBlockingQueue());
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder_$eq(new ThreadPoolExecutor($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_START_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_MAX_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$KEEP_ALIVE_TIME(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$MILLISECONDS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadFactory(), new ThreadPoolExecutor.CallerRunsPolicy()));
            ThreadPoolBuilder threadPoolBuilder2 = $this;
            return threadPoolBuilder2;
        }
    }

    public static ThreadPoolBuilder withNewThreadPoolWithLinkedBlockingQueueWithCapacity(ThreadPoolBuilder $this, int capacity) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.ensureNotActive();
            $this.verifyNotInConstructionPhase();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue_$eq(new LinkedBlockingQueue(capacity));
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder_$eq(new ThreadPoolExecutor($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_START_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_MAX_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$KEEP_ALIVE_TIME(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$MILLISECONDS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadFactory(), new ThreadPoolExecutor.CallerRunsPolicy()));
            ThreadPoolBuilder threadPoolBuilder2 = $this;
            return threadPoolBuilder2;
        }
    }

    public static ThreadPoolBuilder withNewThreadPoolWithSynchronousQueueWithFairness(ThreadPoolBuilder $this, boolean fair) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.ensureNotActive();
            $this.verifyNotInConstructionPhase();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue_$eq(new SynchronousQueue(fair));
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder_$eq(new ThreadPoolExecutor($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_START_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_MAX_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$KEEP_ALIVE_TIME(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$MILLISECONDS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadFactory(), new ThreadPoolExecutor.CallerRunsPolicy()));
            ThreadPoolBuilder threadPoolBuilder2 = $this;
            return threadPoolBuilder2;
        }
    }

    public static ThreadPoolBuilder withNewThreadPoolWithArrayBlockingQueueWithCapacityAndFairness(ThreadPoolBuilder $this, int capacity, boolean fair) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.ensureNotActive();
            $this.verifyNotInConstructionPhase();
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue_$eq(new ArrayBlockingQueue(capacity, fair));
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder_$eq(new ThreadPoolExecutor($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_START_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_MAX_THREADS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$KEEP_ALIVE_TIME(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$MILLISECONDS(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$blockingQueue(), $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadFactory(), new ThreadPoolExecutor.CallerRunsPolicy()));
            ThreadPoolBuilder threadPoolBuilder2 = $this;
            return threadPoolBuilder2;
        }
    }

    public static boolean configureIfPossible(ThreadPoolBuilder $this, Function1 f) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            Boolean bl;
            if ($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$inProcessOfBuilding()) {
                f.apply((Object)$this);
                bl = BoxesRunTime.boxToBoolean((boolean)true);
            } else {
                $this.log().warning((Function0<String>)new ThreadPoolBuilder$.anonfun.configureIfPossible.1($this), $this.getClass().getName(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                bl = BoxesRunTime.boxToBoolean((boolean)false);
            }
            Boolean bl2 = bl;
            return BoxesRunTime.unboxToBoolean((Object)bl2);
        }
    }

    public static ThreadPoolBuilder setCorePoolSize(ThreadPoolBuilder $this, int size$1) {
        return $this.setThreadPoolExecutorProperty((Function1<ThreadPoolExecutor, Object>)new ThreadPoolBuilder$.anonfun.setCorePoolSize.1($this, size$1));
    }

    public static ThreadPoolBuilder setMaxPoolSize(ThreadPoolBuilder $this, int size$2) {
        return $this.setThreadPoolExecutorProperty((Function1<ThreadPoolExecutor, Object>)new ThreadPoolBuilder$.anonfun.setMaxPoolSize.1($this, size$2));
    }

    public static ThreadPoolBuilder setCorePoolSizeFromFactor(ThreadPoolBuilder $this, double multiplier$1) {
        return $this.setThreadPoolExecutorProperty((Function1<ThreadPoolExecutor, Object>)new ThreadPoolBuilder$.anonfun.setCorePoolSizeFromFactor.1($this, multiplier$1));
    }

    public static ThreadPoolBuilder setMaxPoolSizeFromFactor(ThreadPoolBuilder $this, double multiplier$2) {
        return $this.setThreadPoolExecutorProperty((Function1<ThreadPoolExecutor, Object>)new ThreadPoolBuilder$.anonfun.setMaxPoolSizeFromFactor.1($this, multiplier$2));
    }

    public static void setExecutorBounds(ThreadPoolBuilder $this, int bounds) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$boundedExecutorBound_$eq(bounds);
            return;
        }
    }

    public static void setMailboxCapacity(ThreadPoolBuilder $this, int capacity) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.mailboxCapacity_$eq(capacity);
            return;
        }
    }

    public static int procs(ThreadPoolBuilder $this, double multiplier) {
        return (int)Predef$.MODULE$.doubleWrapper((double)Runtime.getRuntime().availableProcessors() * multiplier).ceil();
    }

    public static ThreadPoolBuilder setKeepAliveTimeInMillis(ThreadPoolBuilder $this, long time$1) {
        return $this.setThreadPoolExecutorProperty((Function1<ThreadPoolExecutor, Object>)new ThreadPoolBuilder$.anonfun.setKeepAliveTimeInMillis.1($this, time$1));
    }

    public static ThreadPoolBuilder setRejectionPolicy(ThreadPoolBuilder $this, RejectedExecutionHandler policy$1) {
        return $this.setThreadPoolExecutorProperty((Function1<ThreadPoolExecutor, Object>)new ThreadPoolBuilder$.anonfun.setRejectionPolicy.1($this, policy$1));
    }

    public static ThreadPoolBuilder setAllowCoreThreadTimeout(ThreadPoolBuilder $this, boolean allow$1) {
        return $this.setThreadPoolExecutorProperty((Function1<ThreadPoolExecutor, Object>)new ThreadPoolBuilder$.anonfun.setAllowCoreThreadTimeout.1($this, allow$1));
    }

    public static ThreadPoolBuilder setThreadPoolExecutorProperty(ThreadPoolBuilder $this, Function1 f) {
        ThreadPoolBuilder threadPoolBuilder = $this;
        synchronized (threadPoolBuilder) {
            $this.ensureNotActive();
            $this.verifyInConstructionPhase();
            f.apply((Object)$this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$threadPoolBuilder());
            ThreadPoolBuilder threadPoolBuilder2 = $this;
            return threadPoolBuilder2;
        }
    }

    public static void verifyNotInConstructionPhase(ThreadPoolBuilder $this) {
        if ($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$inProcessOfBuilding()) {
            throw new IllegalActorStateException("Is already in the process of building a thread pool");
        }
        $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$inProcessOfBuilding_$eq(true);
    }

    public static void verifyInConstructionPhase(ThreadPoolBuilder $this) {
        if ($this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$inProcessOfBuilding()) {
            return;
        }
        throw new IllegalActorStateException("Is not in the process of building a thread pool, start building one by invoking one of the 'newThreadPool*' methods");
    }

    public static void $init$(ThreadPoolBuilder $this) {
        $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$_setter_$se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_START_THREADS_$eq(16);
        $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$_setter_$se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$NR_MAX_THREADS_$eq(128);
        $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$_setter_$se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$KEEP_ALIVE_TIME_$eq(60000L);
        $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$_setter_$se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$MILLISECONDS_$eq(TimeUnit.MILLISECONDS);
        $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$boundedExecutorBound_$eq(-1);
        $this.mailboxCapacity_$eq(-1);
        $this.se$scalablesolutions$akka$dispatch$ThreadPoolBuilder$$inProcessOfBuilding_$eq(false);
    }
}

