/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.AuthorizationException;

public class SimpleAuthenticator
implements IAuthenticator {
    public static final String PASSWD_FILENAME_PROPERTY = "passwd.properties";
    public static final String ACCESS_FILENAME_PROPERTY = "access.properties";
    public static final String PMODE_PROPERTY = "passwd.mode";
    public static final String USERNAME_KEY = "username";
    public static final String PASSWORD_KEY = "password";

    @Override
    public void login(String keyspace, AuthenticationRequest authRequest) throws AuthenticationException, AuthorizationException {
        String pmode_plain = System.getProperty(PMODE_PROPERTY);
        PasswordMode mode = PasswordMode.PLAIN;
        if (null != pmode_plain) {
            try {
                mode = PasswordMode.valueOf(pmode_plain);
            }
            catch (Exception e) {
                String mode_values = "";
                for (PasswordMode pm : PasswordMode.values()) {
                    mode_values = mode_values + "'" + (Object)((Object)pm) + "', ";
                }
                mode_values = mode_values + "or leave it unspecified.";
                throw new AuthenticationException("The requested password check mode '" + pmode_plain + "' is not a valid mode.  Possible values are " + mode_values);
            }
        }
        String pfilename = System.getProperty(PASSWD_FILENAME_PROPERTY);
        String username = authRequest.getCredentials().get(USERNAME_KEY);
        if (null == username) {
            throw new AuthenticationException("Authentication request was missing the required key 'username'");
        }
        String password = authRequest.getCredentials().get(PASSWORD_KEY);
        if (null == password) {
            throw new AuthenticationException("Authentication request was missing the required key 'password'");
        }
        boolean authenticated = false;
        try {
            FileInputStream in = new FileInputStream(pfilename);
            Properties props = new Properties();
            props.load(in);
            in.close();
            if (null == props.getProperty(username)) {
                throw new AuthenticationException(SimpleAuthenticator.authenticationErrorMessage(mode, username));
            }
            switch (mode) {
                case PLAIN: {
                    authenticated = password.equals(props.getProperty(username));
                    break;
                }
                case MD5: {
                    authenticated = MessageDigest.isEqual(password.getBytes(), MessageDigest.getInstance("MD5").digest(props.getProperty(username).getBytes()));
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new AuthenticationException("You requested MD5 checking but the MD5 digest algorithm is not available: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Authentication table file given by property passwd.properties could not be found: " + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("Authentication table file given by property passwd.properties could not be opened: " + e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected authentication problem", e);
        }
        if (!authenticated) {
            throw new AuthenticationException(SimpleAuthenticator.authenticationErrorMessage(mode, username));
        }
        String afilename = System.getProperty(ACCESS_FILENAME_PROPERTY);
        boolean authorized = false;
        try {
            FileInputStream in = new FileInputStream(afilename);
            Properties props = new Properties();
            props.load(in);
            in.close();
            if (null == props.getProperty(keyspace)) {
                throw new AuthorizationException(SimpleAuthenticator.authorizationErrorMessage(keyspace, username));
            }
            for (String allow : props.getProperty(keyspace).split(",")) {
                if (!allow.equals(username)) continue;
                authorized = true;
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Authorization table file given by property access.properties could not be found: " + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("Authorization table file given by property access.properties could not be opened: " + e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected authorization problem", e);
        }
        if (!authorized) {
            throw new AuthorizationException(SimpleAuthenticator.authorizationErrorMessage(keyspace, username));
        }
    }

    static String authorizationErrorMessage(String keyspace, String username) {
        return String.format("User %s could not be authorized to use keyspace %s", username, keyspace);
    }

    static String authenticationErrorMessage(PasswordMode mode, String username) {
        return String.format("Given password in password mode %s could not be validated for user %s", new Object[]{mode, username});
    }

    public static enum PasswordMode {
        PLAIN,
        MD5;

    }
}

