/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.avro;

import java.util.Arrays;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.avro.Column;
import org.apache.cassandra.avro.ColumnOrSuperColumn;
import org.apache.cassandra.avro.ColumnPath;
import org.apache.cassandra.avro.ErrorFactory;
import org.apache.cassandra.avro.InvalidRequestException;
import org.apache.cassandra.avro.KeyspaceNotDefinedException;
import org.apache.cassandra.avro.RecordFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;

public class AvroValidation {
    static void validateKey(String key) throws InvalidRequestException {
        if (key.isEmpty()) {
            throw ErrorFactory.newInvalidRequestException("Key may not be empty");
        }
    }

    static void validateKeyspace(String keyspace) throws KeyspaceNotDefinedException {
        if (!DatabaseDescriptor.getTables().contains(keyspace)) {
            throw new KeyspaceNotDefinedException(new Utf8("Keyspace " + keyspace + " does not exist in this schema."));
        }
    }

    static String validateColumnFamily(String keyspace, String columnFamily) throws InvalidRequestException {
        if (columnFamily.isEmpty()) {
            throw ErrorFactory.newInvalidRequestException("non-empty columnfamily is required");
        }
        String cfType = DatabaseDescriptor.getColumnFamilyType(keyspace, columnFamily);
        if (cfType == null) {
            throw ErrorFactory.newInvalidRequestException("unconfigured columnfamily " + columnFamily);
        }
        return cfType;
    }

    static void validateColumnPath(String keyspace, ColumnPath cp) throws InvalidRequestException {
        AvroValidation.validateKeyspace(keyspace);
        String column_family = cp.column_family.toString();
        String cfType = AvroValidation.validateColumnFamily(keyspace, column_family);
        byte[] column = null;
        byte[] super_column = null;
        if (cp.super_column != null) {
            super_column = cp.super_column.array();
        }
        if (cp.column != null) {
            column = cp.column.array();
        }
        if (cfType.equals("Standard")) {
            if (super_column != null) {
                throw ErrorFactory.newInvalidRequestException("supercolumn parameter is invalid for standard CF " + column_family);
            }
            if (column == null) {
                throw ErrorFactory.newInvalidRequestException("column parameter is not optional for standard CF " + column_family);
            }
        } else if (super_column == null) {
            throw ErrorFactory.newInvalidRequestException("supercolumn parameter is not optional for super CF " + column_family);
        }
        if (column != null) {
            AvroValidation.validateColumns(keyspace, column_family, super_column, Arrays.asList(new byte[][]{column}));
        }
        if (super_column != null) {
            AvroValidation.validateColumns(keyspace, column_family, null, Arrays.asList(new byte[][]{super_column}));
        }
    }

    static void validateColumns(String keyspace, String cfName, byte[] superColumnName, Iterable<byte[]> columnNames) throws InvalidRequestException {
        if (superColumnName != null) {
            if (superColumnName.length > 65535) {
                throw ErrorFactory.newInvalidRequestException("supercolumn name length must not be greater than 65535");
            }
            if (superColumnName.length == 0) {
                throw ErrorFactory.newInvalidRequestException("supercolumn name must not be empty");
            }
            if (!DatabaseDescriptor.getColumnFamilyType(keyspace, cfName).equals("Super")) {
                throw ErrorFactory.newInvalidRequestException("supercolumn specified to ColumnFamily " + cfName + " containing normal columns");
            }
        }
        AbstractType comparator = ColumnFamily.getComparatorFor(keyspace, cfName, superColumnName);
        for (byte[] name : columnNames) {
            if (name.length > 65535) {
                throw ErrorFactory.newInvalidRequestException("column name length must not be greater than 65535");
            }
            if (name.length == 0) {
                throw ErrorFactory.newInvalidRequestException("column name must not be empty");
            }
            try {
                comparator.validate(name);
            }
            catch (MarshalException e) {
                throw ErrorFactory.newInvalidRequestException(e.getMessage());
            }
        }
    }

    static void validateColumnOrSuperColumn(String keyspace, String cfName, ColumnOrSuperColumn cosc) throws InvalidRequestException {
        if (cosc.column != null) {
            AvroValidation.validateColumnPath(keyspace, RecordFactory.newColumnPath(cfName, cosc.super_column.name, cosc.column.name));
        }
        if (cosc.super_column != null) {
            for (Column c : cosc.super_column.columns) {
                AvroValidation.validateColumnPath(keyspace, RecordFactory.newColumnPath(cfName, cosc.super_column.name, c.name));
            }
        }
        if (cosc.column == null && cosc.super_column == null) {
            throw ErrorFactory.newInvalidRequestException("ColumnOrSuperColumn must have one or both of Column or SuperColumn");
        }
    }
}

