/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.avro;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.avro.Protocol;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.ipc.AvroRemoteException;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.avro.ColumnOrSuperColumn;
import org.apache.cassandra.avro.ColumnPath;
import org.apache.cassandra.avro.ConsistencyLevel;
import org.apache.cassandra.avro.InvalidRequestException;
import org.apache.cassandra.avro.NotFoundException;
import org.apache.cassandra.avro.TimedOutException;
import org.apache.cassandra.avro.UnavailableException;

public interface Cassandra {
    public static final Protocol PROTOCOL = Protocol.parse((String)"{\"protocol\":\"Cassandra\",\"namespace\":\"org.apache.cassandra.avro\",\"types\":[{\"type\":\"record\",\"name\":\"ColumnPath\",\"fields\":[{\"name\":\"column_family\",\"type\":\"string\"},{\"name\":\"super_column\",\"type\":[\"bytes\",\"null\"]},{\"name\":\"column\",\"type\":[\"bytes\",\"null\"]}]},{\"type\":\"record\",\"name\":\"Column\",\"fields\":[{\"name\":\"name\",\"type\":\"bytes\"},{\"name\":\"value\",\"type\":\"bytes\"},{\"name\":\"timestamp\",\"type\":\"long\"}]},{\"type\":\"record\",\"name\":\"SuperColumn\",\"fields\":[{\"name\":\"name\",\"type\":\"bytes\"},{\"name\":\"columns\",\"type\":{\"type\":\"array\",\"items\":\"Column\"}}]},{\"type\":\"record\",\"name\":\"ColumnOrSuperColumn\",\"fields\":[{\"name\":\"column\",\"type\":[\"Column\",\"null\"]},{\"name\":\"super_column\",\"type\":[\"SuperColumn\",\"null\"]}]},{\"type\":\"enum\",\"name\":\"ConsistencyLevel\",\"symbols\":[\"ZERO\",\"ONE\",\"QUORUM\",\"DCQUORUM\",\"DCQUORUMSYNC\",\"ALL\"]},{\"type\":\"error\",\"name\":\"InvalidRequestException\",\"fields\":[{\"name\":\"why\",\"type\":[\"string\",\"null\"]}]},{\"type\":\"error\",\"name\":\"NotFoundException\",\"fields\":[{\"name\":\"why\",\"type\":[\"string\",\"null\"]}]},{\"type\":\"error\",\"name\":\"UnavailableException\",\"fields\":[{\"name\":\"why\",\"type\":[\"string\",\"null\"]}]},{\"type\":\"error\",\"name\":\"TimedOutException\",\"fields\":[{\"name\":\"why\",\"type\":[\"string\",\"null\"]}]}],\"messages\":{\"get\":{\"request\":[{\"name\":\"keyspace\",\"type\":\"string\"},{\"name\":\"key\",\"type\":\"string\"},{\"name\":\"column_path\",\"type\":\"ColumnPath\"},{\"name\":\"consistency_level\",\"type\":\"ConsistencyLevel\"}],\"response\":\"ColumnOrSuperColumn\",\"errors\":[\"InvalidRequestException\",\"NotFoundException\",\"UnavailableException\",\"TimedOutException\"]},\"insert\":{\"request\":[{\"name\":\"keyspace\",\"type\":\"string\"},{\"name\":\"key\",\"type\":\"string\"},{\"name\":\"column_path\",\"type\":\"ColumnPath\"},{\"name\":\"value\",\"type\":\"bytes\"},{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"consistency_level\",\"type\":\"ConsistencyLevel\"}],\"response\":\"null\",\"errors\":[\"InvalidRequestException\",\"UnavailableException\",\"TimedOutException\"]},\"batch_insert\":{\"request\":[{\"name\":\"keyspace\",\"type\":\"string\"},{\"name\":\"key\",\"type\":\"string\"},{\"name\":\"cfmap\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"array\",\"items\":\"ColumnOrSuperColumn\"}}},{\"name\":\"consistency_level\",\"type\":\"ConsistencyLevel\"}],\"response\":\"null\",\"errors\":[\"InvalidRequestException\",\"UnavailableException\",\"TimedOutException\"]},\"get_api_version\":{\"request\":[],\"response\":\"string\"}}}");
    public static final String __PARANAMER_DATA = "batch_insert org.apache.avro.util.Utf8,org.apache.avro.util.Utf8,java.util.Map,org.apache.cassandra.avro.ConsistencyLevel keyspace,key,cfmap,consistency_level \ninsert org.apache.avro.util.Utf8,org.apache.avro.util.Utf8,org.apache.cassandra.avro.ColumnPath,java.nio.ByteBuffer,long,org.apache.cassandra.avro.ConsistencyLevel keyspace,key,column_path,value,timestamp,consistency_level \nget org.apache.avro.util.Utf8,org.apache.avro.util.Utf8,org.apache.cassandra.avro.ColumnPath,org.apache.cassandra.avro.ConsistencyLevel keyspace,key,column_path,consistency_level \n";

    public ColumnOrSuperColumn get(Utf8 var1, Utf8 var2, ColumnPath var3, ConsistencyLevel var4) throws AvroRemoteException, InvalidRequestException, NotFoundException, UnavailableException, TimedOutException;

    public Void insert(Utf8 var1, Utf8 var2, ColumnPath var3, ByteBuffer var4, long var5, ConsistencyLevel var7) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException;

    public Void batch_insert(Utf8 var1, Utf8 var2, Map<Utf8, GenericArray<ColumnOrSuperColumn>> var3, ConsistencyLevel var4) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException;

    public Utf8 get_api_version() throws AvroRemoteException;
}

