/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.avro;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.SocketServer;
import org.apache.avro.specific.SpecificResponder;
import org.apache.cassandra.avro.Cassandra;
import org.apache.cassandra.avro.CassandraServer;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.CompactionManager;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class CassandraDaemon {
    private static Logger logger = Logger.getLogger(CassandraDaemon.class);
    private SocketServer server;
    private InetAddress listenAddr;
    private int listenPort;

    private void setup() throws IOException {
        String file = System.getProperty("storage-config") + File.separator + "log4j.properties";
        PropertyConfigurator.configure((String)file);
        this.listenPort = DatabaseDescriptor.getThriftPort();
        this.listenAddr = DatabaseDescriptor.getThriftAddress();
        if (this.listenAddr == null) {
            this.listenAddr = FBUtilities.getLocalAddress();
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.error((Object)("Fatal exception in thread " + t), e);
                if (e instanceof OutOfMemoryError) {
                    System.exit(100);
                }
            }
        });
        for (String table : DatabaseDescriptor.getTables()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("opening keyspace " + table));
            }
            Table.open(table);
        }
        CommitLog.recover();
        CompactionManager.instance.checkAllColumnFamilies();
        StorageService.instance.initServer();
    }

    public void load(String[] arguments) throws IOException {
        this.setup();
    }

    public void start() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Binding avro service to %s:%s", this.listenAddr, this.listenPort));
        }
        InetSocketAddress socketAddress = new InetSocketAddress(this.listenAddr, this.listenPort);
        SpecificResponder responder = new SpecificResponder(Cassandra.class, (Object)new CassandraServer());
        logger.info((Object)"Cassandra starting up...");
        this.server = new SocketServer((Responder)responder, (SocketAddress)socketAddress);
    }

    public void stop() {
        logger.info((Object)"Cassandra shutting down...");
        this.server.close();
    }

    public void destroy() {
    }

    public static void main(String[] args) {
        CassandraDaemon daemon = new CassandraDaemon();
        String pidFile = System.getProperty("cassandra-pidfile");
        try {
            daemon.setup();
            if (pidFile != null) {
                new File(pidFile).deleteOnExit();
            }
            if (System.getProperty("cassandra-foreground") == null) {
                System.out.close();
                System.err.close();
            }
            daemon.start();
        }
        catch (Throwable e) {
            String msg = "Exception encountered during startup.";
            logger.error((Object)msg, e);
            System.out.println(msg);
            e.printStackTrace();
            System.exit(3);
        }
    }
}

