/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.avro;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.ipc.AvroRemoteException;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.avro.AvroValidation;
import org.apache.cassandra.avro.Cassandra;
import org.apache.cassandra.avro.Column;
import org.apache.cassandra.avro.ColumnOrSuperColumn;
import org.apache.cassandra.avro.ColumnPath;
import org.apache.cassandra.avro.ConsistencyLevel;
import org.apache.cassandra.avro.ErrorFactory;
import org.apache.cassandra.avro.InvalidRequestException;
import org.apache.cassandra.avro.NotFoundException;
import org.apache.cassandra.avro.RecordFactory;
import org.apache.cassandra.avro.TimedOutException;
import org.apache.cassandra.avro.UnavailableException;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.service.StorageProxy;
import org.apache.log4j.Logger;

public class CassandraServer
implements Cassandra {
    private static Logger logger = Logger.getLogger(CassandraServer.class);
    private static final GenericArray<Column> EMPTY_SUBCOLUMNS = new GenericData.Array(0, Schema.parse((String)("{\"type\":\"array\",\"items\":" + Column.SCHEMA$ + "}")));
    private static final Utf8 API_VERSION = new Utf8("0.0.0");

    @Override
    public ColumnOrSuperColumn get(Utf8 keyspace, Utf8 key, ColumnPath columnPath, ConsistencyLevel consistencyLevel) throws AvroRemoteException, InvalidRequestException, NotFoundException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get");
        }
        ColumnOrSuperColumn column = this.multigetInternal(keyspace.toString(), Arrays.asList(key.toString()), columnPath, consistencyLevel).get(key.toString());
        if (column.column == null && column.super_column == null) {
            throw ErrorFactory.newNotFoundException("Path not found");
        }
        return column;
    }

    private Map<String, ColumnOrSuperColumn> multigetInternal(String keyspace, List<String> keys, ColumnPath cp, ConsistencyLevel level) throws InvalidRequestException, UnavailableException, TimedOutException {
        AvroValidation.validateColumnPath(keyspace, cp);
        byte[] column = cp.column == null ? null : cp.column.array();
        byte[] super_column = cp.super_column == null ? null : cp.super_column.array();
        QueryPath path = new QueryPath(cp.column_family.toString(), column == null ? null : super_column);
        List<byte[]> nameAsList = Arrays.asList(new byte[][]{column == null ? super_column : column});
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>();
        for (String key : keys) {
            AvroValidation.validateKey(key);
            commands.add(new SliceByNamesReadCommand(keyspace, key, path, nameAsList));
        }
        HashMap<String, ColumnOrSuperColumn> columnFamiliesMap = new HashMap<String, ColumnOrSuperColumn>();
        Map<String, Collection<IColumn>> columnsMap = this.multigetColumns(commands, level);
        for (ReadCommand command : commands) {
            ColumnOrSuperColumn columnorsupercolumn;
            Collection<IColumn> columns = columnsMap.get(command.key);
            if (columns == null) {
                columnorsupercolumn = new ColumnOrSuperColumn();
            } else {
                assert (columns.size() == 1);
                IColumn col = columns.iterator().next();
                columnorsupercolumn = col.isMarkedForDelete() ? new ColumnOrSuperColumn() : (col instanceof org.apache.cassandra.db.Column ? RecordFactory.newColumnOrSuperColumn(RecordFactory.newColumn(col.name(), col.value(), col.timestamp())) : RecordFactory.newColumnOrSuperColumn(RecordFactory.newSuperColumn(col.name(), this.avronateSubColumns(col.getSubColumns()))));
            }
            columnFamiliesMap.put(command.key, columnorsupercolumn);
        }
        return columnFamiliesMap;
    }

    private Map<String, Collection<IColumn>> multigetColumns(List<ReadCommand> commands, ConsistencyLevel level) throws InvalidRequestException, UnavailableException, TimedOutException {
        Map<String, ColumnFamily> cfamilies = this.readColumnFamily(commands, level);
        HashMap<String, Collection<IColumn>> columnFamiliesMap = new HashMap<String, Collection<IColumn>>();
        for (ReadCommand command : commands) {
            ColumnFamily cfamily = cfamilies.get(command.key);
            if (cfamily == null) continue;
            Collection<IColumn> columns = null;
            if (command.queryPath.superColumnName != null) {
                IColumn column = cfamily.getColumn(command.queryPath.superColumnName);
                if (column != null) {
                    columns = column.getSubColumns();
                }
            } else {
                columns = cfamily.getSortedColumns();
            }
            if (columns == null || columns.size() == 0) continue;
            columnFamiliesMap.put(command.key, columns);
        }
        return columnFamiliesMap;
    }

    protected Map<String, ColumnFamily> readColumnFamily(List<ReadCommand> commands, ConsistencyLevel consistency) throws InvalidRequestException, UnavailableException, TimedOutException {
        List<Row> rows;
        HashMap<String, ColumnFamily> columnFamilyKeyMap = new HashMap<String, ColumnFamily>();
        if (consistency == ConsistencyLevel.ZERO) {
            throw ErrorFactory.newInvalidRequestException("Consistency level zero may not be applied to read operations");
        }
        if (consistency == ConsistencyLevel.ALL) {
            throw ErrorFactory.newInvalidRequestException("Consistency level all is not yet supported on read operations");
        }
        try {
            rows = StorageProxy.readProtocol(commands, this.thriftConsistencyLevel(consistency));
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (org.apache.cassandra.thrift.UnavailableException e) {
            throw new UnavailableException();
        }
        for (Row row : rows) {
            columnFamilyKeyMap.put(row.key, row.cf);
        }
        return columnFamilyKeyMap;
    }

    public GenericArray<Column> avronateSubColumns(Collection<IColumn> columns) {
        if (columns == null || columns.isEmpty()) {
            return EMPTY_SUBCOLUMNS;
        }
        GenericData.Array avroColumns = new GenericData.Array(columns.size(), Column.SCHEMA$);
        for (IColumn column : columns) {
            if (column.isMarkedForDelete()) continue;
            Column avroColumn = RecordFactory.newColumn(column.name(), column.value(), column.timestamp());
            avroColumns.add((Object)avroColumn);
        }
        return avroColumns;
    }

    @Override
    public Void insert(Utf8 keyspace, Utf8 key, ColumnPath cp, ByteBuffer value, long timestamp, ConsistencyLevel consistencyLevel) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"insert");
        }
        byte[] column = cp.column == null ? null : cp.column.array();
        byte[] super_column = cp.super_column == null ? null : cp.super_column.array();
        String column_family = cp.column_family.toString();
        String keyspace_string = keyspace.toString();
        AvroValidation.validateKey(keyspace_string);
        AvroValidation.validateColumnPath(keyspace_string, cp);
        RowMutation rm = new RowMutation(keyspace_string, key.toString());
        try {
            rm.add(new QueryPath(column_family, super_column, column), value.array(), timestamp);
        }
        catch (MarshalException e) {
            throw ErrorFactory.newInvalidRequestException(e.getMessage());
        }
        this.doInsert(consistencyLevel, rm);
        return null;
    }

    private void doInsert(ConsistencyLevel consistency, RowMutation rm) throws UnavailableException, TimedOutException {
        if (consistency != ConsistencyLevel.ZERO) {
            try {
                StorageProxy.mutateBlocking(Arrays.asList(rm), this.thriftConsistencyLevel(consistency));
            }
            catch (TimeoutException e) {
                throw new TimedOutException();
            }
            catch (org.apache.cassandra.thrift.UnavailableException thriftE) {
                throw new UnavailableException();
            }
        } else {
            StorageProxy.mutate(Arrays.asList(rm));
        }
    }

    @Override
    public Void batch_insert(Utf8 keyspace, Utf8 key, Map<Utf8, GenericArray<ColumnOrSuperColumn>> cfmap, ConsistencyLevel consistency) throws AvroRemoteException, InvalidRequestException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"batch_insert");
        }
        String keyString = key.toString();
        String keyspaceString = keyspace.toString();
        AvroValidation.validateKey(keyString);
        for (Utf8 cfName : cfmap.keySet()) {
            for (ColumnOrSuperColumn cosc : cfmap.get(cfName)) {
                AvroValidation.validateColumnOrSuperColumn(keyspaceString, cfName.toString(), cosc);
            }
        }
        this.doInsert(consistency, CassandraServer.getRowMutation(keyspaceString, keyString, cfmap));
        return null;
    }

    private static RowMutation getRowMutation(String keyspace, String key, Map<Utf8, GenericArray<ColumnOrSuperColumn>> cfmap) {
        RowMutation rm = new RowMutation(keyspace, key.trim());
        for (Map.Entry<Utf8, GenericArray<ColumnOrSuperColumn>> entry : cfmap.entrySet()) {
            String cfName = entry.getKey().toString();
            for (ColumnOrSuperColumn cosc : entry.getValue()) {
                if (cosc.column == null) {
                    assert (cosc.super_column != null);
                    for (Column column : cosc.super_column.columns) {
                        QueryPath path = new QueryPath(cfName, cosc.super_column.name.array(), column.name.array());
                        rm.add(path, column.value.array(), column.timestamp);
                    }
                    continue;
                }
                assert (cosc.super_column == null);
                QueryPath path = new QueryPath(cfName, null, cosc.column.name.array());
                rm.add(path, cosc.column.value.array(), cosc.column.timestamp);
            }
        }
        return rm;
    }

    private org.apache.cassandra.thrift.ConsistencyLevel thriftConsistencyLevel(ConsistencyLevel consistency) {
        switch (consistency) {
            case ZERO: {
                return org.apache.cassandra.thrift.ConsistencyLevel.ZERO;
            }
            case ONE: {
                return org.apache.cassandra.thrift.ConsistencyLevel.ONE;
            }
            case QUORUM: {
                return org.apache.cassandra.thrift.ConsistencyLevel.QUORUM;
            }
            case DCQUORUM: {
                return org.apache.cassandra.thrift.ConsistencyLevel.DCQUORUM;
            }
            case DCQUORUMSYNC: {
                return org.apache.cassandra.thrift.ConsistencyLevel.DCQUORUMSYNC;
            }
            case ALL: {
                return org.apache.cassandra.thrift.ConsistencyLevel.ALL;
            }
        }
        return null;
    }

    @Override
    public Utf8 get_api_version() throws AvroRemoteException {
        return API_VERSION;
    }
}

