/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.avro;

import java.nio.ByteBuffer;
import org.apache.avro.generic.GenericArray;
import org.apache.cassandra.avro.Column;
import org.apache.cassandra.avro.ColumnOrSuperColumn;
import org.apache.cassandra.avro.ColumnPath;
import org.apache.cassandra.avro.SuperColumn;

class RecordFactory {
    RecordFactory() {
    }

    static Column newColumn(ByteBuffer name, ByteBuffer value, long timestamp) {
        Column column = new Column();
        column.name = name;
        column.value = value;
        column.timestamp = timestamp;
        return column;
    }

    static Column newColumn(byte[] name, byte[] value, long timestamp) {
        return RecordFactory.newColumn(ByteBuffer.wrap(name), ByteBuffer.wrap(value), timestamp);
    }

    static SuperColumn newSuperColumn(ByteBuffer name, GenericArray<Column> columns) {
        SuperColumn column = new SuperColumn();
        column.name = name;
        column.columns = columns;
        return column;
    }

    static SuperColumn newSuperColumn(byte[] name, GenericArray<Column> columns) {
        return RecordFactory.newSuperColumn(ByteBuffer.wrap(name), columns);
    }

    static ColumnOrSuperColumn newColumnOrSuperColumn(Column column) {
        ColumnOrSuperColumn col = new ColumnOrSuperColumn();
        col.column = column;
        return col;
    }

    static ColumnOrSuperColumn newColumnOrSuperColumn(SuperColumn superColumn) {
        ColumnOrSuperColumn column = new ColumnOrSuperColumn();
        column.super_column = superColumn;
        return column;
    }

    static ColumnPath newColumnPath(String cfName, ByteBuffer superColumn, ByteBuffer column) {
        ColumnPath cPath = new ColumnPath();
        cPath.super_column = superColumn;
        cPath.column = column;
        return cPath;
    }
}

