/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import com.reardencommerce.kernel.collections.shared.evictable.ConcurrentLinkedHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class InstrumentedCache<K, V> {
    private int capacity;
    private final ConcurrentLinkedHashMap<K, V> map;
    private final AtomicLong requests = new AtomicLong(0L);
    private final AtomicLong hits = new AtomicLong(0L);
    private final AtomicLong lastRequests = new AtomicLong(0L);
    private final AtomicLong lastHits = new AtomicLong(0L);

    public InstrumentedCache(int capacity) {
        this.capacity = capacity;
        this.map = ConcurrentLinkedHashMap.create((ConcurrentLinkedHashMap.EvictionPolicy)ConcurrentLinkedHashMap.EvictionPolicy.SECOND_CHANCE, (int)capacity);
    }

    public void put(K key, V value) {
        this.map.put(key, value);
    }

    public V get(K key) {
        Object v = this.map.get(key);
        this.requests.incrementAndGet();
        if (v != null) {
            this.hits.incrementAndGet();
        }
        return (V)v;
    }

    public V getInternal(K key) {
        return (V)this.map.get(key);
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.map.setCapacity(capacity);
        this.capacity = capacity;
    }

    public int getSize() {
        return this.map.size();
    }

    public long getHits() {
        return this.hits.get();
    }

    public long getRequests() {
        return this.requests.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getRecentHitRate() {
        long r = this.requests.get();
        long h = this.hits.get();
        try {
            double d = (double)(h - this.lastHits.get()) / (double)(r - this.lastRequests.get());
            return d;
        }
        finally {
            this.lastRequests.set(r);
            this.lastHits.set(h);
        }
    }

    public void clear() {
        this.map.clear();
        this.requests.set(0L);
        this.hits.set(0L);
    }
}

