/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cli;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.cassandra.cli.CliCompiler;
import org.apache.cassandra.cli.CliMain;
import org.apache.cassandra.cli.CliSessionState;
import org.apache.cassandra.cli.CliUtils;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.cassandra.thrift.ThriftGlue;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.thrift.TException;

public class CliClient {
    private Cassandra.Client thriftClient_ = null;
    private CliSessionState css_ = null;
    private Map<String, Map<String, Map<String, String>>> keyspacesMap = new HashMap<String, Map<String, Map<String, String>>>();

    public CliClient(CliSessionState css, Cassandra.Client thriftClient) {
        this.css_ = css;
        this.thriftClient_ = thriftClient;
    }

    public void executeCLIStmt(String stmt) throws TException, NotFoundException, InvalidRequestException, UnavailableException, TimedOutException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        CommonTree ast = null;
        ast = CliCompiler.compileQuery(stmt);
        try {
            switch (ast.getType()) {
                case 6: {
                    this.cleanupAndExit();
                    break;
                }
                case 13: {
                    this.executeGet(ast);
                    break;
                }
                case 7: {
                    this.printCmdHelp();
                    break;
                }
                case 14: {
                    this.executeSet(ast);
                    break;
                }
                case 16: {
                    this.executeDelete(ast);
                    break;
                }
                case 15: {
                    this.executeCount(ast);
                    break;
                }
                case 9: {
                    this.executeShowProperty(ast, "cluster name");
                    break;
                }
                case 10: {
                    this.executeShowProperty(ast, "config file");
                    break;
                }
                case 11: {
                    this.executeShowProperty(ast, "version");
                    break;
                }
                case 12: {
                    this.executeShowTables(ast);
                    break;
                }
                case 5: {
                    this.executeDescribeTable(ast);
                    break;
                }
                case 4: {
                    this.executeConnect(ast);
                    break;
                }
                case 8: {
                    break;
                }
                default: {
                    this.css_.err.println("Invalid Statement (Type: " + ast.getType() + ")");
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to encode string as UTF-8", e);
        }
    }

    private void printCmdHelp() {
        this.css_.out.println("List of all CLI commands:");
        this.css_.out.println("?                                                                  Same as help.");
        this.css_.out.println("help                                                          Display this help.");
        this.css_.out.println("connect <hostname>/<port>                             Connect to thrift service.");
        this.css_.out.println("describe keyspace <keyspacename>                              Describe keyspace.");
        this.css_.out.println("exit                                                                   Exit CLI.");
        this.css_.out.println("quit                                                                   Exit CLI.");
        this.css_.out.println("show config file                                Display contents of config file.");
        this.css_.out.println("show cluster name                                          Display cluster name.");
        this.css_.out.println("show keyspaces                                           Show list of keyspaces.");
        this.css_.out.println("show api version                                        Show server API version.");
        this.css_.out.println("get <ksp>.<cf>['<key>']                                  Get a slice of columns.");
        this.css_.out.println("get <ksp>.<cf>['<key>']['<super>']                   Get a slice of sub columns.");
        this.css_.out.println("get <ksp>.<cf>['<key>']['<col>']                             Get a column value.");
        this.css_.out.println("get <ksp>.<cf>['<key>']['<super>']['<col>']              Get a sub column value.");
        this.css_.out.println("set <ksp>.<cf>['<key>']['<col>'] = '<value>'                       Set a column.");
        this.css_.out.println("set <ksp>.<cf>['<key>']['<super>']['<col>'] = '<value>'        Set a sub column.");
        this.css_.out.println("del <ksp>.<cf>['<key>']                                           Delete record.");
        this.css_.out.println("del <ksp>.<cf>['<key>']['<col>']                                  Delete column.");
        this.css_.out.println("del <ksp>.<cf>['<key>']['<super>']['<col>']                   Delete sub column.");
        this.css_.out.println("count <ksp>.<cf>['<key>']                               Count columns in record.");
        this.css_.out.println("count <ksp>.<cf>['<key>']['<super>']            Count columns in a super column.");
    }

    private void cleanupAndExit() {
        CliMain.disconnect();
        System.exit(0);
    }

    Map<String, Map<String, String>> getCFMetaData(String keyspace) throws NotFoundException, TException {
        if (!this.keyspacesMap.containsKey(keyspace)) {
            this.keyspacesMap.put(keyspace, this.thriftClient_.describe_keyspace(keyspace));
        }
        return this.keyspacesMap.get(keyspace);
    }

    private void executeCount(CommonTree ast) throws TException, InvalidRequestException, UnavailableException, TimedOutException, UnsupportedEncodingException {
        ColumnParent colParent;
        if (!CliMain.isConnected()) {
            return;
        }
        int childCount = ast.getChildCount();
        assert (childCount == 1);
        CommonTree columnFamilySpec = (CommonTree)ast.getChild(0);
        assert (columnFamilySpec.getType() == 17);
        String tableName = CliCompiler.getTableName(columnFamilySpec);
        String key = CliCompiler.getKey(columnFamilySpec);
        String columnFamily = CliCompiler.getColumnFamily(columnFamilySpec);
        int columnSpecCnt = CliCompiler.numColumnSpecifiers(columnFamilySpec);
        if (columnSpecCnt == 0) {
            colParent = ThriftGlue.createColumnParent(columnFamily, null);
        } else {
            assert (columnSpecCnt == 1);
            colParent = ThriftGlue.createColumnParent(columnFamily, CliCompiler.getColumn(columnFamilySpec, 0).getBytes("UTF-8"));
        }
        int count = this.thriftClient_.get_count(tableName, key, colParent, ConsistencyLevel.ONE);
        this.css_.out.printf("%d columns\n", count);
    }

    private void executeDelete(CommonTree ast) throws TException, InvalidRequestException, UnavailableException, TimedOutException, UnsupportedEncodingException {
        boolean isSuper;
        if (!CliMain.isConnected()) {
            return;
        }
        int childCount = ast.getChildCount();
        assert (childCount == 1);
        CommonTree columnFamilySpec = (CommonTree)ast.getChild(0);
        assert (columnFamilySpec.getType() == 17);
        String tableName = CliCompiler.getTableName(columnFamilySpec);
        String key = CliCompiler.getKey(columnFamilySpec);
        String columnFamily = CliCompiler.getColumnFamily(columnFamilySpec);
        int columnSpecCnt = CliCompiler.numColumnSpecifiers(columnFamilySpec);
        byte[] superColumnName = null;
        byte[] columnName = null;
        try {
            if (!this.getCFMetaData(tableName).containsKey(columnFamily)) {
                this.css_.out.println("No such column family: " + columnFamily);
                return;
            }
            isSuper = this.getCFMetaData(tableName).get(columnFamily).get("Type").equals("Super");
        }
        catch (NotFoundException nfe) {
            this.css_.out.printf("No such keyspace: %s\n", tableName);
            return;
        }
        if (columnSpecCnt < 0 || columnSpecCnt > 2) {
            this.css_.out.println("Invalid row, super column, or column specification.");
            return;
        }
        if (columnSpecCnt == 1) {
            if (isSuper) {
                superColumnName = CliCompiler.getColumn(columnFamilySpec, 0).getBytes("UTF-8");
            } else {
                columnName = CliCompiler.getColumn(columnFamilySpec, 0).getBytes("UTF-8");
            }
        } else if (columnSpecCnt == 2) {
            superColumnName = CliCompiler.getColumn(columnFamilySpec, 0).getBytes("UTF-8");
            columnName = CliCompiler.getColumn(columnFamilySpec, 1).getBytes("UTF-8");
        }
        this.thriftClient_.remove(tableName, key, ThriftGlue.createColumnPath(columnFamily, superColumnName, columnName), CliClient.timestampMicros(), ConsistencyLevel.ONE);
        this.css_.out.println(String.format("%s removed.", columnSpecCnt == 0 ? "row" : "column"));
    }

    private static long timestampMicros() {
        return System.currentTimeMillis() * 1000L;
    }

    private void doSlice(String keyspace, String key, String columnFamily, byte[] superColumnName) throws InvalidRequestException, UnavailableException, TimedOutException, TException, UnsupportedEncodingException, IllegalAccessException, NotFoundException, InstantiationException, ClassNotFoundException {
        SliceRange range = new SliceRange(ArrayUtils.EMPTY_BYTE_ARRAY, ArrayUtils.EMPTY_BYTE_ARRAY, true, 1000000);
        List<ColumnOrSuperColumn> columns = this.thriftClient_.get_slice(keyspace, key, ThriftGlue.createColumnParent(columnFamily, superColumnName), ThriftGlue.createSlicePredicate(null, range), ConsistencyLevel.ONE);
        int size = columns.size();
        for (ColumnOrSuperColumn cosc : columns) {
            if (cosc.isSetSuper_column()) {
                SuperColumn superColumn = cosc.super_column;
                this.css_.out.printf("=> (super_column=%s,", this.formatSuperColumnName(keyspace, columnFamily, superColumn));
                for (Column col : superColumn.getColumns()) {
                    this.css_.out.printf("\n     (column=%s, value=%s, timestamp=%d)", this.formatSubcolumnName(keyspace, columnFamily, col), new String(col.value, "UTF-8"), col.timestamp);
                }
                this.css_.out.println(")");
                continue;
            }
            Column column = cosc.column;
            this.css_.out.printf("=> (column=%s, value=%s, timestamp=%d)\n", this.formatColumnName(keyspace, columnFamily, column), new String(column.value, "UTF-8"), column.timestamp);
        }
        this.css_.out.println("Returned " + size + " results.");
    }

    private String formatSuperColumnName(String keyspace, String columnFamily, SuperColumn column) throws NotFoundException, TException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        return this.getFormatTypeForColumn(this.getCFMetaData(keyspace).get(columnFamily).get("CompareWith")).getString(column.name);
    }

    private String formatSubcolumnName(String keyspace, String columnFamily, Column subcolumn) throws NotFoundException, TException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        return this.getFormatTypeForColumn(this.getCFMetaData(keyspace).get(columnFamily).get("CompareSubcolumnsWith")).getString(subcolumn.name);
    }

    private String formatColumnName(String keyspace, String columnFamily, Column column) throws ClassNotFoundException, NotFoundException, TException, IllegalAccessException, InstantiationException {
        return this.getFormatTypeForColumn(this.getCFMetaData(keyspace).get(columnFamily).get("CompareWith")).getString(column.name);
    }

    private AbstractType getFormatTypeForColumn(String compareWith) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        AbstractType type;
        try {
            type = (AbstractType)Class.forName(compareWith).newInstance();
        }
        catch (ClassNotFoundException e) {
            type = (AbstractType)BytesType.class.newInstance();
        }
        return type;
    }

    private void executeGet(CommonTree ast) throws TException, NotFoundException, InvalidRequestException, UnavailableException, TimedOutException, UnsupportedEncodingException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (!CliMain.isConnected()) {
            return;
        }
        assert (ast.getChildCount() == 1) : "serious parsing error (this is a bug).";
        CommonTree columnFamilySpec = (CommonTree)ast.getChild(0);
        assert (columnFamilySpec.getType() == 17);
        String tableName = CliCompiler.getTableName(columnFamilySpec);
        String key = CliCompiler.getKey(columnFamilySpec);
        String columnFamily = CliCompiler.getColumnFamily(columnFamilySpec);
        int columnSpecCnt = CliCompiler.numColumnSpecifiers(columnFamilySpec);
        if (!this.getCFMetaData(tableName).containsKey(columnFamily)) {
            this.css_.out.println("No such column family: " + columnFamily);
            return;
        }
        boolean isSuper = this.getCFMetaData(tableName).get(columnFamily).get("Type").equals("Super");
        byte[] superColumnName = null;
        byte[] columnName = null;
        if (columnSpecCnt == 0) {
            this.doSlice(tableName, key, columnFamily, superColumnName);
            return;
        }
        if (columnSpecCnt == 1) {
            if (isSuper) {
                superColumnName = CliCompiler.getColumn(columnFamilySpec, 0).getBytes("UTF-8");
                this.doSlice(tableName, key, columnFamily, superColumnName);
                return;
            }
            columnName = CliCompiler.getColumn(columnFamilySpec, 0).getBytes("UTF-8");
        } else if (columnSpecCnt == 2) {
            superColumnName = CliCompiler.getColumn(columnFamilySpec, 0).getBytes("UTF-8");
            columnName = CliCompiler.getColumn(columnFamilySpec, 1).getBytes("UTF-8");
        } else {
            this.css_.out.println("Invalid row, super column, or column specification.");
            return;
        }
        ColumnPath path = ThriftGlue.createColumnPath(columnFamily, superColumnName, columnName);
        Column column = this.thriftClient_.get((String)tableName, (String)key, (ColumnPath)path, (ConsistencyLevel)ConsistencyLevel.ONE).column;
        this.css_.out.printf("=> (column=%s, value=%s, timestamp=%d)\n", this.formatColumnName(tableName, columnFamily, column), new String(column.value, "UTF-8"), column.timestamp);
    }

    private void executeSet(CommonTree ast) throws TException, InvalidRequestException, UnavailableException, TimedOutException, UnsupportedEncodingException {
        if (!CliMain.isConnected()) {
            return;
        }
        assert (ast.getChildCount() == 2) : "serious parsing error (this is a bug).";
        CommonTree columnFamilySpec = (CommonTree)ast.getChild(0);
        assert (columnFamilySpec.getType() == 17);
        String tableName = CliCompiler.getTableName(columnFamilySpec);
        String key = CliCompiler.getKey(columnFamilySpec);
        String columnFamily = CliCompiler.getColumnFamily(columnFamilySpec);
        int columnSpecCnt = CliCompiler.numColumnSpecifiers(columnFamilySpec);
        String value = CliUtils.unescapeSQLString(ast.getChild(1).getText());
        byte[] superColumnName = null;
        byte[] columnName = null;
        if (columnSpecCnt == 0) {
            this.css_.err.println("No column name specified, (type 'help' or '?' for help on syntax).");
            return;
        }
        if (columnSpecCnt == 1) {
            columnName = CliCompiler.getColumn(columnFamilySpec, 0).getBytes("UTF-8");
        } else {
            assert (columnSpecCnt == 2) : "serious parsing error (this is a bug).";
            superColumnName = CliCompiler.getColumn(columnFamilySpec, 0).getBytes("UTF-8");
            columnName = CliCompiler.getColumn(columnFamilySpec, 1).getBytes("UTF-8");
        }
        this.thriftClient_.insert(tableName, key, ThriftGlue.createColumnPath(columnFamily, superColumnName, columnName), value.getBytes(), CliClient.timestampMicros(), ConsistencyLevel.ONE);
        this.css_.out.println("Value inserted.");
    }

    private void executeShowProperty(CommonTree ast, String propertyName) throws TException {
        if (!CliMain.isConnected()) {
            return;
        }
        String propertyValue = this.thriftClient_.get_string_property(propertyName);
        this.css_.out.println(propertyValue);
    }

    private void executeShowTables(CommonTree ast) throws TException {
        if (!CliMain.isConnected()) {
            return;
        }
        List<String> tables = this.thriftClient_.get_string_list_property("keyspaces");
        for (String table : tables) {
            this.css_.out.println(table);
        }
    }

    private void executeDescribeTable(CommonTree ast) throws TException {
        if (!CliMain.isConnected()) {
            return;
        }
        int childCount = ast.getChildCount();
        assert (childCount == 1);
        String tableName = ast.getChild(0).getText();
        if (tableName == null) {
            this.css_.out.println("Keyspace argument required");
            return;
        }
        try {
            Map<String, Map<String, String>> columnFamiliesMap = this.thriftClient_.describe_keyspace(tableName);
            for (String columnFamilyName : columnFamiliesMap.keySet()) {
                Map<String, String> columnMap = columnFamiliesMap.get(columnFamilyName);
                String desc = columnMap.get("Desc");
                String columnFamilyType = columnMap.get("Type");
                String sort = columnMap.get("CompareWith");
                String flushperiod = columnMap.get("FlushPeriodInMinutes");
                this.css_.out.println(desc);
                this.css_.out.println("Column Family Type: " + columnFamilyType);
                this.css_.out.println("Column Sorted By: " + sort);
                this.css_.out.println("flush period: " + flushperiod + " minutes");
                this.css_.out.println("------");
            }
        }
        catch (NotFoundException e) {
            this.css_.out.println("Keyspace " + tableName + " could not be found.");
        }
    }

    private void executeConnect(CommonTree ast) {
        int portNumber = Integer.parseInt(ast.getChild(1).getText());
        Tree idList = ast.getChild(0);
        StringBuilder hostName = new StringBuilder();
        int idCount = idList.getChildCount();
        for (int idx = 0; idx < idCount; ++idx) {
            hostName.append(idList.getChild(idx).getText());
        }
        CliMain.disconnect();
        this.css_.hostName = hostName.toString();
        this.css_.thriftPort = portNumber;
        CliMain.connect(this.css_.hostName, this.css_.thriftPort);
    }
}

