/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cli;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.cassandra.cli.CliLexer;
import org.apache.cassandra.cli.CliParser;
import org.apache.cassandra.cli.CliUtils;

public class CliCompiler {
    public static CommonTree compileQuery(String query) {
        CommonTree queryTree = null;
        try {
            ANTLRNoCaseStringStream input = new ANTLRNoCaseStringStream(query);
            CliLexer lexer = new CliLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            CliParser parser = new CliParser((TokenStream)tokens);
            queryTree = (CommonTree)parser.root().getTree();
        }
        catch (Exception e) {
            System.err.println("Exception " + e.getMessage());
            e.printStackTrace(System.err);
        }
        return queryTree;
    }

    public static String getTableName(CommonTree astNode) {
        assert (astNode.getType() == 17);
        return astNode.getChild(0).getText();
    }

    public static String getColumnFamily(CommonTree astNode) {
        assert (astNode.getType() == 17);
        return astNode.getChild(1).getText();
    }

    public static String getKey(CommonTree astNode) {
        assert (astNode.getType() == 17);
        return CliUtils.unescapeSQLString(astNode.getChild(2).getText());
    }

    public static int numColumnSpecifiers(CommonTree astNode) {
        return astNode.getChildCount() - 3;
    }

    public static String getColumn(CommonTree astNode, int pos) {
        return CliUtils.unescapeSQLString(astNode.getChild(pos + 3).getText());
    }

    public static class ANTLRNoCaseStringStream
    extends ANTLRStringStream {
        public ANTLRNoCaseStringStream(String input) {
            super(input);
        }

        public int LA(int i) {
            int returnChar = super.LA(i);
            if (returnChar == -1) {
                return returnChar;
            }
            if (returnChar == 0) {
                return returnChar;
            }
            return Character.toUpperCase((char)returnChar);
        }
    }
}

