/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cli;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import jline.Completor;
import jline.ConsoleReader;
import jline.History;
import org.apache.cassandra.cli.CliClient;
import org.apache.cassandra.cli.CliCompleter;
import org.apache.cassandra.cli.CliOptions;
import org.apache.cassandra.cli.CliSessionState;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

public class CliMain {
    public static final String PROMPT = "cassandra";
    public static final String HISTORYFILE = ".cassandra.history";
    private static TTransport transport_ = null;
    private static Cassandra.Client thriftClient_ = null;
    private static CliSessionState css_ = new CliSessionState();
    private static CliClient cliClient_;
    private static CliCompleter completer_;

    public static void connect(String server, int port) {
        String clusterName;
        TSocket socket = new TSocket(server, port);
        if (transport_ != null) {
            transport_.close();
        }
        transport_ = CliMain.css_.framed ? new TFramedTransport((TTransport)socket) : socket;
        TBinaryProtocol binaryProtocol = new TBinaryProtocol(transport_, false, false);
        Cassandra.Client cassandraClient = new Cassandra.Client((TProtocol)binaryProtocol);
        try {
            transport_.open();
        }
        catch (Exception e) {
            CliMain.css_.err.format("Exception connecting to %s/%d - %s\n", server, port, e.getMessage());
            if (CliMain.css_.debug) {
                e.printStackTrace();
            }
            return;
        }
        thriftClient_ = cassandraClient;
        cliClient_ = new CliClient(css_, thriftClient_);
        if (CliMain.css_.username != null && CliMain.css_.password != null && CliMain.css_.keyspace != null) {
            HashMap<String, String> credentials = new HashMap<String, String>();
            credentials.put("username", CliMain.css_.username);
            credentials.put("password", CliMain.css_.password);
            AuthenticationRequest authRequest = new AuthenticationRequest(credentials);
            try {
                thriftClient_.login(CliMain.css_.keyspace, authRequest);
            }
            catch (AuthenticationException e) {
                CliMain.css_.err.println("Exception during authentication to the cassandra node, verify you are using correct credentials.");
                return;
            }
            catch (AuthorizationException e) {
                CliMain.css_.err.println("You are not authorized to use keyspace: " + CliMain.css_.keyspace);
                return;
            }
            catch (TException e) {
                if (CliMain.css_.debug) {
                    e.printStackTrace();
                }
                CliMain.css_.err.println("Login failure. Did you specify 'keyspace', 'username' and 'password'?");
                return;
            }
        }
        try {
            clusterName = thriftClient_.get_string_property("cluster name");
        }
        catch (Exception e) {
            CliMain.css_.err.println("Exception retrieving information about the cassandra node, check you have connected to the thrift port.");
            if (CliMain.css_.debug) {
                e.printStackTrace();
            }
            return;
        }
        try {
            for (String keyspace : thriftClient_.get_string_list_property("keyspaces")) {
                if (keyspace.equals("system")) continue;
                for (String cf : cliClient_.getCFMetaData(keyspace).keySet()) {
                    for (String cmd : completer_.getKeyspaceCommands()) {
                        completer_.addCandidateString(String.format("%s %s.%s", cmd, keyspace, cf));
                    }
                }
            }
        }
        catch (Exception e) {
            if (CliMain.css_.debug) {
                e.printStackTrace();
            }
            return;
        }
        CliMain.css_.out.printf("Connected to: \"%s\" on %s/%d%n", clusterName, server, port);
    }

    public static void disconnect() {
        if (transport_ != null) {
            transport_.close();
            transport_ = null;
        }
    }

    private static void printBanner() {
        CliMain.css_.out.println("Welcome to cassandra CLI.\n");
        CliMain.css_.out.println("Type 'help' or '?' for help. Type 'quit' or 'exit' to quit.");
    }

    public static boolean isConnected() {
        if (thriftClient_ == null) {
            CliMain.css_.out.println("Not connected to a cassandra instance.");
            return false;
        }
        return true;
    }

    private static void processCLIStmt(String query) {
        block4: {
            try {
                cliClient_.executeCLIStmt(query);
            }
            catch (InvalidRequestException ire) {
                CliMain.css_.err.println(ire.why);
                if (CliMain.css_.debug) {
                    ire.printStackTrace();
                }
            }
            catch (Exception e) {
                CliMain.css_.err.println("Exception " + e.getMessage());
                if (!CliMain.css_.debug) break block4;
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        String line;
        CliOptions cliOptions = new CliOptions();
        cliOptions.processArgs(css_, args);
        if (CliMain.css_.hostName != null) {
            CliMain.connect(CliMain.css_.hostName, CliMain.css_.thriftPort);
        }
        if (cliClient_ == null) {
            cliClient_ = new CliClient(css_, null);
        }
        ConsoleReader reader = new ConsoleReader();
        reader.addCompletor((Completor)completer_);
        reader.setBellEnabled(false);
        String historyFile = System.getProperty("user.home") + File.separator + HISTORYFILE;
        try {
            History history = new History(new File(historyFile));
            reader.setHistory(history);
        }
        catch (IOException exp) {
            CliMain.css_.err.printf("Unable to open %s for writing%n", historyFile);
        }
        CliMain.printBanner();
        while ((line = reader.readLine("cassandra> ")) != null) {
            CliMain.processCLIStmt(line);
        }
    }

    static {
        completer_ = new CliCompleter();
    }
}

