/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cli;

import org.apache.cassandra.cli.CliSessionState;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class CliOptions {
    private static Options options = null;
    private CommandLine cmd = null;
    private static final String HOST_OPTION = "host";
    private static final String PORT_OPTION = "port";
    private static final String FRAME_OPTION = "framed";
    private static final String DEBUG_OPTION = "debug";
    private static final String USERNAME_OPTION = "username";
    private static final String PASSWORD_OPTION = "password";
    private static final String KEYSPACE_OPTION = "keyspace";
    private static final int DEFAULT_THRIFT_PORT = 9160;

    private static void printUsage() {
        System.err.println("");
        System.err.println("Usage: cassandra-cli --host hostname [--port <portname>] [--framed] [--debug] [--username username] [--password password] [--keyspace keyspace]");
        System.err.println("");
    }

    public void processArgs(CliSessionState css, String[] args) {
        PosixParser parser = new PosixParser();
        try {
            this.cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            CliOptions.printUsage();
            e.printStackTrace();
            System.exit(1);
        }
        css.hostName = !this.cmd.hasOption(HOST_OPTION) ? null : this.cmd.getOptionValue(HOST_OPTION);
        if (this.cmd.hasOption(FRAME_OPTION)) {
            css.framed = true;
        }
        if (this.cmd.hasOption(DEBUG_OPTION)) {
            css.debug = true;
        }
        css.thriftPort = this.cmd.hasOption(PORT_OPTION) ? Integer.parseInt(this.cmd.getOptionValue(PORT_OPTION)) : 9160;
        if (this.cmd.hasOption(USERNAME_OPTION)) {
            css.username = this.cmd.getOptionValue(USERNAME_OPTION);
        }
        if (this.cmd.hasOption(PASSWORD_OPTION)) {
            css.password = this.cmd.getOptionValue(PASSWORD_OPTION);
        }
        if (this.cmd.hasOption(KEYSPACE_OPTION)) {
            css.keyspace = this.cmd.getOptionValue(KEYSPACE_OPTION);
        }
    }

    static {
        options = new Options();
        options.addOption(HOST_OPTION, true, "cassandra server's host name");
        options.addOption(PORT_OPTION, true, "cassandra server's thrift port");
        options.addOption(FRAME_OPTION, false, "cassandra server's framed transport");
        options.addOption(DEBUG_OPTION, false, "display stack traces");
        options.addOption(USERNAME_OPTION, true, "username for cassandra authentication");
        options.addOption(PASSWORD_OPTION, true, "password for cassandra authentication");
        options.addOption(KEYSPACE_OPTION, true, "cassandra keyspace user is authenticated against");
    }
}

