/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CassandraServer;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.json.simple.JSONValue;

public class RingCache {
    private static final Logger logger_ = Logger.getLogger(RingCache.class);
    private Set<String> seeds_ = new HashSet<String>();
    private final int port_ = DatabaseDescriptor.getThriftPort();
    private static final IPartitioner partitioner_ = DatabaseDescriptor.getPartitioner();
    private TokenMetadata tokenMetadata;

    public RingCache() {
        for (InetAddress seed : DatabaseDescriptor.getSeeds()) {
            this.seeds_.add(seed.getHostAddress());
        }
        this.refreshEndPointMap();
    }

    public void refreshEndPointMap() {
        for (String seed : this.seeds_) {
            try {
                TSocket socket = new TSocket(seed, this.port_);
                TBinaryProtocol binaryProtocol = new TBinaryProtocol((TTransport)socket, false, false);
                Cassandra.Client client = new Cassandra.Client((TProtocol)binaryProtocol);
                socket.open();
                Map tokenToHostMap = (Map)JSONValue.parse((String)client.get_string_property(CassandraServer.TOKEN_MAP));
                HashBiMap tokenEndpointMap = HashBiMap.create();
                for (Map.Entry entry : tokenToHostMap.entrySet()) {
                    Token token = StorageService.getPartitioner().getTokenFactory().fromString((String)entry.getKey());
                    String host = (String)entry.getValue();
                    try {
                        tokenEndpointMap.put(token, (Object)InetAddress.getByName(host));
                    }
                    catch (UnknownHostException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                this.tokenMetadata = new TokenMetadata((BiMap<Token, InetAddress>)tokenEndpointMap);
                break;
            }
            catch (TException e) {
                logger_.debug((Object)("Error contacting seed " + seed + " " + e.getMessage()));
            }
        }
    }

    public List<InetAddress> getEndPoint(String table, String key) {
        if (this.tokenMetadata == null) {
            throw new RuntimeException("Must refresh endpoints before looking up a key.");
        }
        AbstractReplicationStrategy strat = StorageService.getReplicationStrategy(this.tokenMetadata, table);
        return strat.getNaturalEndpoints((Token)partitioner_.getToken(key), table);
    }
}

